####################################
### 1. Inputs for module `infra` ###
####################################

variable "aws_region" {
  description = "AWS region for deploying resources."
  type        = string
  default     = "us-east-1"
}

variable "eks_cluster" {
  description = "Name of the EKS cluster to be created."
  type        = string
}

variable "eks_version" {
  description = "Version of the EKS cluster to be created."
  type        = string
  default     = "1.31"
}

variable "vpc_cidr" {
  description = "CIDR for VPC to be created."
  type        = string
  default     = "10.0.0.0/16"
}

#############################################
### 2. Inputs for module `exostellar_iam` ###
#############################################


###########################################################
### 3. Inputs for module `exostellar_management_server` ###
###########################################################

variable "domain_name" {
  description = "Domain name to run Exostellar Management Server (EMS) in. Optional."
  type        = string
  default     = ""
}

variable "ssh_key_name" {
  description = "SSH key-pair's name for Exostellar Management Server (EMS)'s access."
  type        = string
}

variable "ems_ami_id" {
  description = "Mapping of AWS region to Exostellar Management Server (EMS)'s AMI."
  type        = string
}

variable "ems_instance_type" {
  description = "EC2 instance type for Exostellar Management Server (EMS)."
  type        = string
  default     = "m5d.xlarge"
}

variable "ems_volume_size_gb" {
  description = "Volume size (in GB) for Exostellar Management Server (EMS)."
  type        = number
  default     = 100
}

variable "profile_availability_zone" {
  description = "Exostellar profile's availability zone."
  type        = string
  default     = ""
}

variable "ems_termination_protection" {
  description = "Enable termination protection for Exostellar Management Server (EMS)'s EC2 instance?"
  type        = bool
  default     = true
}

variable "xspot_enable_hyperthreading" {
  description = "Enable hyperthreading in Xspot?"
  type        = bool
  default     = true
}

variable "xspot_enable_balloon" {
  description = "Enable ballooning in Xspot?"
  type        = bool
  default     = true
}

variable "nfs_dns_name" {
  description = "DNS name of the NFS file system for Exostellar Management Server (EMS)."
  type        = string
  default     = ""
}

variable "nfs_security_group_id" {
  description = "Security group ID that enable traffic between the NFS server and Exostellar Management Server (EMS)."
  type        = string
  default     = ""
}

#########################################
### 4. Inputs for module `xkarpenter` ###
#########################################

variable "exostellar_management_server_port" {
  description = "Exostellar management server (EMS)'s port to listen on."
  type        = string
  default     = "5000"
}

variable "xkarpenter_helm_chart_repository" {
  description = "Exostellar's Karpenter (xkarpenter)'s Helm chart's repository URL."
  type        = string
  default     = "oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter"
}

variable "xkarpenter_namespace" {
  description = "Exostellar's Karpenter (xkarpenter)'s namespace."
  type        = string
  default     = "exokarpenter"
}

variable "pod_resource_limits" {
  description = "Pod resource requests and limits."
  type = map(
    object(
      {
        cpu    = number
        memory = string
      },
    ),
  )
  default = {
    requests = {
      cpu    = 1
      memory = "1Gi"
    }
    limits = {
      cpu    = 1
      memory = "1Gi"
    }
  }
}

variable "xkarpenter_version" {
  description = "Exostellar's Karpenter (xkarpenter)'s Helm chart's version."
  type        = string
  default     = "v2.0.2"
}
