output "vpc_id" {
  description = "ID of the VPC associated with the EKS cluster."
  value       = module.xio_infra.vpc_id
}

output "vpc_azs" {
  description = "Availability zones list of the VPC associated with the EKS cluster."
  value       = module.xio_infra.vpc_azs
}

output "public_subnets" {
  description = "Public subnets associated with the EKS cluster."
  value       = module.xio_infra.public_subnets
}

output "private_subnets" {
  description = "Private subnets associated with the EKS cluster."
  value       = module.xio_infra.private_subnets
}

output "nat_gateways" {
  description = "NAT gateways associated with the EKS cluster."
  value       = module.xio_infra.nat_gateways
}

output "internet_gateway" {
  description = "Internet gateway associated with the EKS cluster."
  value       = module.xio_infra.internet_gateway
}

output "eks_cluster_arn" {
  description = "The EKS cluster's ARN."
  value       = module.xio_infra.eks_cluster_arn
}

output "eks_cluster_endpoint" {
  description = "The EKS cluster's endpoint."
  value       = module.xio_infra.eks_cluster_endpoint
}

output "eks_cluster_status" {
  description = "The EKS cluster's status."
  value       = module.xio_infra.eks_cluster_status
}

output "eks_cluster_security_group_id" {
  description = "ID of the security group associated with the EKS cluster."
  value       = module.xio_infra.eks_cluster_security_group_id
}


output "xspot_controller_role_arn" {
  description = "Xspot controller's IAM role's ARN."
  value       = module.exostellar_iam.xspot_controller_role_arn
}

output "xspot_controller_instance_profile_arn" {
  description = "Xspot controller's IAM instance profile's ARN."
  value       = module.exostellar_iam.xspot_controller_instance_profile_arn
}

output "xspot_worker_role_arn" {
  description = "Xspot worker's IAM role's ARN."
  value       = module.exostellar_iam.xspot_worker_role_arn
}

output "xspot_worker_instance_profile_arn" {
  description = "Xspot worker's IAM instance profile's ARN."
  value       = module.exostellar_iam.xspot_worker_instance_profile_arn
}

output "ems_public_ip" {
  description = "Exostellar Management Server (EMS)'s public IP."
  value       = module.exostellar_management_server.exostellar_management_server_public_ip
}

output "ems_private_ip" {
  description = "Exostellar Management Server (EMS)'s private IP."
  value       = module.exostellar_management_server.exostellar_management_server_private_ip
}

output "ems_console_admin_username" {
  description = "Exostellar Management Server (EMS) console's admin username for login."
  value       = module.exostellar_management_server.exostellar_management_server_console_admin_username
}

output "ems_console_admin_password" {
  description = "Exostellar Management Server (EMS) console's initial admin password for login. Change on first login."
  value       = module.exostellar_management_server.exostellar_management_server_console_admin_password
}

output "eks_cluster" {
  description = "EKS cluster's name."
  value       = module.exostellar_management_server.eks_cluster
}

output "xkarpenter_namespace" {
  description = "Exostellar's Karpenter (xkarpenter)'s namespace."
  value       = module.xkarpenter.namespace
}

output "xkarpenter_version" {
  description = "Exostellar's Karpenter (xkarpenter)'s Helm chart's version."
  value       = module.xkarpenter.version
}
