variable "helm_chart_repository" {
  description = "Exostellar's Karpenter (xkarpenter)'s Helm chart's repository URL."
  type        = string
  default     = "oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter"
}

variable "exostellar_management_server_private_ip" {
  description = "Exostellar management server (EMS)'s private IP address."
  type        = string
}

variable "exostellar_management_server_port" {
  description = "Exostellar management server (EMS)'s port to listen on."
  type        = string
  default     = "5000"
}

variable "eks_cluster" {
  description = "EKS cluster's name."
  type        = string
}

variable "xkarpenter_version" {
  description = "Exostellar's Karpenter (xkarpenter)'s Helm chart's version."
  type        = string
  default     = "v2.0.2"
}

variable "namespace" {
  description = "Exostellar's Karpenter (xkarpenter)'s namespace."
  type        = string
  default     = "exokarpenter"
}

variable "pod_resources" {
  description = "Pod resource requests and limits."
  type = map(
    object(
      {
        cpu    = number
        memory = string
      },
    ),
  )
  default = {
    requests = {
      cpu    = 1
      memory = "1Gi"
    }
    limits = {
      cpu    = 1
      memory = "1Gi"
    }
  }
}

variable "xspot_controller_instance_profile_arn" {
  description = "Xspot controller's instance-profile's ARN"
  type        = string
}

variable "xspot_worker_instance_profile_arn" {
  description = "Xspot worker's instance-profile's ARN"
  type        = string
}
