resource "helm_release" "xkarpenter" {
  name             = "xkarpenter"
  chart            = var.helm_chart_repository
  version          = var.xkarpenter_version
  namespace        = var.namespace
  create_namespace = true

  set {
    name  = "settings.clusterName"
    value = var.eks_cluster
  }

  set {
    name  = "settings.resources.requests.cpu"
    value = var.pod_resources.requests.cpu
  }

  set {
    name  = "settings.resources.requests.memory"
    value = var.pod_resources.requests.memory
  }

  set {
    name  = "settings.resources.limits.cpu"
    value = var.pod_resources.limits.cpu
  }

  set {
    name  = "settings.resources.limits.memory"
    value = var.pod_resources.limits.memory
  }

  set {
    name  = "headnode"
    value = "http://${var.exostellar_management_server_private_ip}:${var.exostellar_management_server_port}"
  }

  set {
    name  = "defaultControllerRole"
    value = var.xspot_controller_instance_profile_arn
  }

  set {
    name  = "defaultWorkerRole"
    value = var.xspot_worker_instance_profile_arn
  }
}
