# Exostellar's Karpenter (xkarpenter) Module

This deploys the Exostellar's Karpenter (xkarpenter) using the Helm chart.

# Prerequisites

1. A functional EKS cluster and configured in kube config (`~/.kube/config`).
    > Recommended to use the [infra](../infra/) module to create the EKS cluster.
2. IAM module from [here](../iam/). Next step requires this to be installed.
3. EMS module from [here](../ems/). The Exostellar Management Server (EMS)'s private IP address is required as input to
current module.

# Usage

Create the Karpenter module with inputs, similar to the example: [karpenter](../../examples/karpenter/README.md).

Deploy the Exostellar's Karpenter (xkarpenter) using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [helm](https://registry.terraform.io/providers/hashicorp/helm/latest) | 2.17.0 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| helm_release.xkarpenter | resource |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| helm_chart_repository | Exostellar's Karpenter (xkarpenter)'s Helm chart's repository URL. | `string` | `"oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter"` | no |
| exostellar_management_server_private_ip | Exostellar management server (EMS)'s private IP address. | `string` | `null` | yes |
| exostellar_management_server_port | Exostellar management server (EMS)'s port to listen on. | `string` | `"5000"` | no |
| eks_cluster | EKS cluster's name. | `string` | `null` | yes |
| xkarpenter_version | Exostellar's Karpenter (xkarpenter)'s Helm chart's version. | `string` | `"v2.0.2"` | no |
| namespace | Exostellar's Karpenter (xkarpenter)'s namespace. | `string` | `"exokarpenter"` | no |
| pod_resources | Pod resource requests and limits. | <pre>map(<br>  object(<br>    {<br>      cpu    = number<br>      memory = string<br>    },<br>  ),<br>) | <pre>{<br>  requests = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>  limits = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>} | no |
| xspot_controller_instance_profile_arn | Xspot controller's instance-profile's ARN | `string` | `null` | yes |
| xspot_worker_instance_profile_arn | Xspot worker's instance-profile's ARN | `string` | `null` | yes |

## Outputs

| Name | Description |
|------|-------------|
| namespace | Exostellar's Karpenter (xkarpenter)'s namespace. |
| version | Exostellar's Karpenter (xkarpenter)'s Helm chart's version. |
