output "vpc_id" {
  description = "ID of the VPC associated with the EKS cluster."
  value       = module.vpc.vpc_id
}

output "vpc_azs" {
  description = "Availability zones list of the VPC associated with the EKS cluster."
  value       = module.vpc.azs
}

output "public_subnets" {
  description = "Public subnets associated with the EKS cluster."
  value       = module.vpc.public_subnets
}

output "private_subnets" {
  description = "Private subnets associated with the EKS cluster."
  value       = module.vpc.private_subnets
}

output "nat_gateways" {
  description = "NAT gateways associated with the EKS cluster."
  value       = module.vpc.natgw_ids
}

output "internet_gateway" {
  description = "Internet gateway associated with the EKS cluster."
  value       = module.vpc.igw_id
}

output "eks_cluster_arn" {
  description = "The EKS cluster's ARN."
  value       = module.eks.cluster_arn
}

output "eks_cluster_endpoint" {
  description = "The EKS cluster's endpoint."
  value       = module.eks.cluster_endpoint
}

output "eks_cluster_status" {
  description = "The EKS cluster's status."
  value       = module.eks.cluster_status
}

output "eks_addons" {
  description = "The EKS cluster's add-ons list."
  value       = module.eks.cluster_addons
}

output "eks_cluster_security_group_id" {
  description = "ID of the security group associated with the EKS cluster."
  value       = module.eks.cluster_security_group_id
}

output "eks_cluster_additional_security_group_ids" {
  description = "Additional security groups associated with the EKS cluster."
  value       = [module.eks.node_security_group_id]
}

output "eks_cluster" {
  description = "EKS cluster's name."
  value       = var.eks_cluster
}

output "aws_region" {
  description = "AWS region for deploying resources."
  value       = var.aws_region
}

output "eks_version" {
  description = "Version of the EKS cluster created."
  value       = var.eks_version
}
