# Exostellar's Infra Module

This deploys the EKS cluster and related resources.
Note: The EKS cluster has specs suitable for deploying Exostellar Management Server (EMS) using [ems](../ems/).

# Prerequisites

1. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).

# Usage

Deploy the EMS and related resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/latest) | 5.87.0 |


## Modules

| Name | Source | Version |
|------|--------|---------|
| terraform-aws-modules/vpc/aws | [terraform-aws-modules/vpc/aws](https://registry.terraform.io/modules/terraform-aws-modules/vpc/aws/5.13.0) | 5.13.0 |
| terraform-aws-modules/eks/aws | [terraform-aws-modules/eks/aws](https://registry.terraform.io/modules/terraform-aws-modules/eks/aws/20.0.0) | 20.0.0 |
| terraform-aws-modules/iam/aws//modules/iam-role-for-service-accounts-eks | [terraform-aws-modules/iam/aws//modules/iam-role-for-service-accounts-eks](https://registry.terraform.io/modules/terraform-aws-modules/iam/aws/latest/submodules/iam-role-for-service-accounts-eks) | latest

## Resources

| Name | Type |
|------|------|
| aws_availability_zones.available | data source | 

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_region | AWS region for deploying resources. | `string` | `"us-east-1"` | no |
| vpc_cidr | CIDR for VPC to be created. | `string` | `"10.0.0.0/16"` | no |
| eks_cluster | Name of the EKS cluster to be created. | `string` | `null` | yes |
| eks_version | Version of the EKS cluster to be created. | `string` | `"1.31"` | no |

## Outputs

| Name | Description |
|------|-------------|
| vpc_id | ID of the VPC associated with the EKS cluster. |
| vpc_azs | Availability zones list of the VPC associated with the EKS cluster. |
| public_subnets | Public subnets associated with the EKS cluster. |
| private_subnets | Private subnets associated with the EKS cluster. |
| nat_gateways | NAT gateways associated with the EKS cluster. |
| internet_gateway | Internet gateway associated with the EKS cluster. |
| eks_cluster_arn | The EKS cluster's ARN. |
| eks_cluster_endpoint | The EKS cluster's endpoint. |
| eks_cluster_status | The EKS cluster's status. |
| eks_addons | The EKS cluster's add-ons list. |
| eks_cluster_security_group_id | ID of the security group associated with the EKS cluster. |
| eks_cluster | EKS cluster's name. |
| aws_region | AWS region in which resources are deployed. |
