locals {
  module_tags = {
    cluster = var.eks_cluster
    region  = var.aws_region
  }
}

data "aws_iam_policy_document" "instance_assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]
    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
  }
}

data "aws_iam_policy" "managed_ec2_container_registry_readonly" {
  arn = "arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly"
}

data "aws_iam_policy" "managed_ssm_managed_instance_core" {
  arn = "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore"
}

data "aws_iam_policy" "managed_eks_cni_policy" {
  arn = "arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy"
}

data "aws_iam_policy" "managed_eks_worker_node_policy" {
  arn = "arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy"
}

data "aws_iam_policy" "managed_ebs_csi_driver_policy" {
  arn = "arn:aws:iam::aws:policy/service-role/AmazonEBSCSIDriverPolicy"
}

resource "aws_iam_role" "xspot_controller_role" {
  name               = "${var.eks_cluster}-xspot-controller"
  assume_role_policy = data.aws_iam_policy_document.instance_assume_role_policy.json
  tags               = local.module_tags
}

resource "aws_iam_role_policy" "xspot_controller_role_policy" {
  name   = "${var.eks_cluster}-xspot-controller"
  role   = aws_iam_role.xspot_controller_role.id
  policy = file("${path.module}/policy/xspot-controller.json")
}

resource "aws_iam_instance_profile" "xspot_controller_instance_profile" {
  name = "${var.eks_cluster}-xspot-controller"
  role = aws_iam_role.xspot_controller_role.name
  tags = local.module_tags
}

resource "aws_iam_role" "xspot_worker_role" {
  name               = "${var.eks_cluster}-xspot-worker"
  assume_role_policy = data.aws_iam_policy_document.instance_assume_role_policy.json
  tags               = local.module_tags
}

resource "aws_iam_role_policy" "xspot_worker_role_policy" {
  name   = "${var.eks_cluster}-xspot-worker"
  role   = aws_iam_role.xspot_worker_role.id
  policy = file("${path.module}/policy/xspot-worker.json")
}

resource "aws_iam_instance_profile" "xspot_worker_instance_profile" {
  name = "${var.eks_cluster}-xspot-worker"
  role = aws_iam_role.xspot_worker_role.name
  tags = local.module_tags
}

resource "aws_iam_role_policy_attachment" "worker_managed_role_attachment_0" {
  role       = aws_iam_role.xspot_worker_role.name
  policy_arn = data.aws_iam_policy.managed_ec2_container_registry_readonly.arn
}

resource "aws_iam_role_policy_attachment" "worker_managed_role_attachment_1" {
  role       = aws_iam_role.xspot_worker_role.name
  policy_arn = data.aws_iam_policy.managed_ssm_managed_instance_core.arn
}

resource "aws_iam_role_policy_attachment" "worker_managed_role_attachment_2" {
  role       = aws_iam_role.xspot_worker_role.name
  policy_arn = data.aws_iam_policy.managed_eks_cni_policy.arn
}

resource "aws_iam_role_policy_attachment" "worker_managed_role_attachment_3" {
  role       = aws_iam_role.xspot_worker_role.name
  policy_arn = data.aws_iam_policy.managed_eks_worker_node_policy.arn
}

resource "aws_iam_role_policy_attachment" "worker_managed_role_attachment_4" {
  role       = aws_iam_role.xspot_worker_role.name
  policy_arn = data.aws_iam_policy.managed_ebs_csi_driver_policy.arn
}
