# Exostellar's IAM Module

This deploys the Exostellar's IAM resources.

# Prerequisites

1. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
2. A functional EKS cluster and configured in kube config (`~/.kube/config`).
    > Recommended to use the [infra](../infra/) module to create the EKS cluster.

# Usage

Create the IAM module with inputs, similar to the example: [exostellar_iam](../../examples/iam/README.md).

Deploy the Exostellar IAM resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/latest) | 5.87.0 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| aws_iam_policy_document.instance_assume_role_policy | data source |
| aws_iam_policy.managed_ec2_container_registry_readonly | data source |
| aws_iam_policy.managed_ssm_managed_instance_core | data source |
| aws_iam_policy.managed_eks_cni_policy | data source |
| aws_iam_policy.managed_eks_worker_node_policy | data source |
| aws_iam_policy.managed_ebs_csi_driver_policy | data source |
| aws_iam_role.xspot_controller_role | resource |
| aws_iam_role_policy.xspot_controller_role_policy | resource |
| aws_iam_instance_profile.xspot_controller_instance_profile | resource |
| aws_iam_role.xspot_worker_role | resource |
| aws_iam_role_policy.xspot_worker_role_policy | resource |
| aws_iam_instance_profile.xspot_worker_instance_profile | resource |
| aws_iam_role_policy_attachment.worker_managed_role_attachment_0 | resource |
| aws_iam_role_policy_attachment.worker_managed_role_attachment_1 | resource |
| aws_iam_role_policy_attachment.worker_managed_role_attachment_2 | resource |
| aws_iam_role_policy_attachment.worker_managed_role_attachment_3 | resource |
| aws_iam_role_policy_attachment.worker_managed_role_attachment_4 | resource |

## Inputs


| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_region | AWS region for deploying resources | `string` | `"us-east-1"` | no
| eks_cluster | EKS cluster's name | `string` | `null` | yes

## Outputs

| Name | Description |
|------|-------------|
| xspot_controller_role_arn | Xspot controller's IAM role's ARN. |
| xspot_controller_instance_profile_arn | Xspot controller's IAM instance profile's ARN. |
| xspot_worker_role_arn | Xspot worker's IAM role's ARN. |
| xspot_worker_instance_profile_arn | Xspot worker's IAM instance profile's ARN. |
| eks_cluster | EKS cluster's name. |
| aws_region | AWS region in which resources are deployed. |
