variable "aws_region" {
  description = "AWS region for deploying resources."
  type        = string
  default     = "us-east-1"
}

variable "eks_cluster" {
  description = "EKS cluster's name."
  type        = string
}

variable "vpc_id" {
  description = "EKS cluster's VPC ID."
  type        = string
}

variable "subnet_id" {
  description = "EKS cluster's subnet ID."
  type        = string
}

variable "is_subnet_public" {
  description = "Is EKS cluster's subnet public?"
  type        = bool
  default     = true
}

variable "domain_name" {
  description = "Domain name to run Exostellar Management Server (EMS) in. Optional."
  type        = string
  default     = ""
}

variable "shared_security_group_ids" {
  description = "Share security groups' IDs to attach to Exostellar Management Server (EMS). Optional."
  type        = list(string)
  default     = []
}

variable "instance_type" {
  description = "EC2 instance type for Exostellar Management Server (EMS)."
  type        = string
  default     = "m5d.xlarge"
}

variable "volume_size" {
  description = "Volume size (in GB) for Exostellar Management Server (EMS)."
  type        = number
  default     = 100
}

variable "ssh_key_name" {
  description = "SSH key-pair's name for Exostellar Management Server (EMS)'s access."
  type        = string
}

variable "termination_protection" {
  description = "Enable termination protection for Exostellar Management Server (EMS)'s EC2 instance?"
  type        = bool
  default     = true
}

variable "region_ami_map" {
  description = "Mapping of AWS region to Exostellar Management Server (EMS)'s AMI."
  type        = map(string)
  default = {
    "us-east-1" = "ami-04cca0eda7be65264"
    "us-east-2" = "ami-03adac9e7909c6b6d"
    "us-west-1" = "ami-0e565d37973b78814"
    "us-west-2" = "ami-0acfce874af4ce257"
  }
}

variable "nfs_dns_name" {
  description = "DNS name of the NFS file system for Exostellar Management Server (EMS)."
  type        = string
  default     = ""
}

variable "nfs_security_group_id" {
  description = "Security group ID that enable traffic between the NFS server and Exostellar Management Server (EMS)."
  type        = string
  default     = ""
}

variable "xspot_controller_subnet_id" {
  description = "Xspot controller's subnet ID."
  type        = string
}

variable "xspot_worker_subnet_id" {
  description = "Xspot worker's subnet ID."
  type        = string
}

variable "xspot_enable_hyperthreading" {
  description = "Enable hyperthreading in Xspot?"
  type        = bool
  default     = true
}

variable "xspot_enable_balloon" {
  description = "Enable ballooning in Xspot?"
  type        = bool
  default     = true
}

variable "profile_az" {
  description = "Exostellar profile's availability zone."
  type        = string
  default     = ""
}

variable "environment_image_name" {
  description = "Exostellar's application environment's image name."
  type        = string
  default     = "k8s-131"
}

variable "xspot_controller_instance_profile_arn" {
  description = "Xspot controller's instance-profile's ARN"
  type        = string
  default     = ""
}

variable "xspot_worker_instance_profile_arn" {
  description = "Xspot worker's instance-profile's ARN"
  type        = string
  default     = ""
}
