# Exostellar's EMS Module

This deploys the Exostellar Management Server (EMS) and related resources.

# Prerequisites

1. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
2. A functional EKS cluster and configured in kube config (`~/.kube/config`).
    > Recommended to use the [infra](../infra/) module to create the EKS cluster.
3. SSH key-pair whose name must be specified in var `ssh_key_name` in [main.tf](main.tf). 
4. IAM module from [here](../iam/).

# Usage

Create the EMS module with inputs, similar to the example: [ems](../../examples/ems/README.md).

Deploy the EMS and related resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/latest) | 5.87.0 |
| [helm](https://registry.terraform.io/providers/hashicorp/helm/latest) | 2.17.0 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| aws_vpc.cluster_vpc | data source |
| aws_subnet.cluster_subnet | data source |
| aws_iam_policy_document.instance_assume_role_policy | data source |
| aws_security_group.exostellar_management_server | resource |
| aws_iam_role.exostellar_management_server | resource |
| aws_iam_role_policy.exostellar_management_server | resource |
| aws_iam_instance_profile.exostellar_management_server | resource |
| aws_instance.exostellar_management_server | resource |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_region | AWS region for deploying resources. | `string` | `"us-east-1"` | no |
| eks_cluster | EKS cluster's name. | `string` | `null` | yes |
| vpc_id | EKS cluster's VPC ID. | `string` | `null` | yes |
| subnet_id | EKS cluster's subnet ID. | `string` | `null` | yes |
| is_subnet_public | Is EKS cluster's subnet public? | `bool` | `true` | no |
| domain_name | Domain name to run Exostellar Management Server (EMS) in. Optional. | `string` | `""` | no |
| shared_security_group_ids | Share security groups' IDs to attach to Exostellar Management Server (EMS). Optional. | `list(string)` | `[]` | no |
| instance_type | EC2 instance type for Exostellar Management Server (EMS). | `string` | `"m5d.xlarge"` | no |
| volume_size | Volume size (in GB) for Exostellar Management Server (EMS). | `number` | `100` | no |
| ssh_key_name | SSH key-pair's name for Exostellar Management Server (EMS)'s access. | `string` | `null` | yes |
| termination_protection | Enable termination protection for Exostellar Management Server (EMS)'s EC2 instance? | `bool` | `true` | no |
| region_ami_map | Mapping of AWS region to Exostellar Management Server (EMS)'s AMI. | `map(string)` |<pre>{<br>  "us-east-1" = "ami-04cca0eda7be65264"<br>  "us-east-2" = "ami-03adac9e7909c6b6d"<br>  "us-west-1" = "ami-0e565d37973b78814"<br>  "us-west-2" = "ami-0acfce874af4ce257"<br>} | no |
| nfs_dns_name | DNS name of the NFS file system for Exostellar Management Server (EMS). | `string` | `""` | no |
| nfs_security_group_id | Security group ID that enable traffic between the NFS server and Exostellar Management Server (EMS). | `string` | `""` | no |
| xspot_controller_subnet_id | Xspot controller's subnet ID. | `string` | `null` | yes |
| xspot_controller_instance_profile_arn | Xspot controller's instance profile's ARN | `string` | `null` | yes |
| xspot_worker_subnet_id | Xspot worker's subnet ID. | `string` | `null` | yes |
| xspot_worker_instance_profile_arn | Xspot worker's instance profile's ARN | `string` | `null` | yes |
| xspot_enable_hyperthreading | Enable hyperthreading in Xspot? | `bool` | `true` | no |
| xspot_enable_balloon | Enable ballooning in Xspot? | `bool` | `true` | no |
| profile_az | Exostellar profile's availability zone. | `string` | `""` | no |
| environment_image_name | Exostellar's application environment's image name. | `string` | `"k8s-131"` | no |

## Outputs

| Name | Description |
|------|-------------|
| exostellar_management_server_public_ip | Exostellar Management Server (EMS)'s public IP. |
| exostellar_management_server_private_ip | Exostellar Management Server (EMS)'s private IP. |
| exostellar_management_server_console_admin_username | Exostellar Management Server (EMS) console's admin username for login. |
| exostellar_management_server_console_admin_password | Exostellar Management Server (EMS) console's initial admin password for login. Change on first login. |
| eks_cluster | EKS cluster's name. |
