output "vpc_id" {
  description = "ID of the VPC associated with the EKS cluster."
  value       = module.standalone_flow.vpc_id
}

output "vpc_azs" {
  description = "Availability zones list of the VPC associated with the EKS cluster."
  value       = module.standalone_flow.vpc_azs
}

output "public_subnets" {
  description = "Public subnets associated with the EKS cluster."
  value       = module.standalone_flow.public_subnets
}

output "private_subnets" {
  description = "Private subnets associated with the EKS cluster."
  value       = module.standalone_flow.private_subnets
}

output "nat_gateways" {
  description = "NAT gateways associated with the EKS cluster."
  value       = module.standalone_flow.nat_gateways
}

output "internet_gateway" {
  description = "Internet gateway associated with the EKS cluster."
  value       = module.standalone_flow.internet_gateway
}

output "eks_cluster_arn" {
  description = "The EKS cluster's ARN."
  value       = module.standalone_flow.eks_cluster_arn
}

output "eks_cluster_endpoint" {
  description = "The EKS cluster's endpoint."
  value       = module.standalone_flow.eks_cluster_endpoint
}

output "eks_cluster_status" {
  description = "The EKS cluster's status."
  value       = module.standalone_flow.eks_cluster_status
}

output "eks_cluster_security_group_id" {
  description = "ID of the security group associated with the EKS cluster."
  value       = module.standalone_flow.eks_cluster_security_group_id
}


output "xspot_controller_role_arn" {
  description = "Xspot controller's IAM role's ARN."
  value       = module.standalone_flow.xspot_controller_role_arn
}

output "xspot_controller_instance_profile_arn" {
  description = "Xspot controller's IAM instance profile's ARN."
  value       = module.standalone_flow.xspot_controller_instance_profile_arn
}

output "xspot_worker_role_arn" {
  description = "Xspot worker's IAM role's ARN."
  value       = module.standalone_flow.xspot_worker_role_arn
}

output "xspot_worker_instance_profile_arn" {
  description = "Xspot worker's IAM instance profile's ARN."
  value       = module.standalone_flow.xspot_worker_instance_profile_arn
}

output "ems_public_ip" {
  description = "Exostellar Management Server (EMS)'s public IP."
  value       = module.standalone_flow.ems_public_ip
}

output "ems_private_ip" {
  description = "Exostellar Management Server (EMS)'s private IP."
  value       = module.standalone_flow.ems_private_ip
}

output "ems_console_admin_username" {
  description = "Exostellar Management Server (EMS) console's admin username for login."
  value       = module.standalone_flow.ems_console_admin_username
}

output "ems_console_admin_password" {
  description = "Exostellar Management Server (EMS) console's initial admin password for login. Change on first login."
  value       = module.standalone_flow.ems_console_admin_password
}

output "eks_cluster" {
  description = "EKS cluster's name."
  value       = module.standalone_flow.eks_cluster
}

output "xkarpenter_namespace" {
  description = "Exostellar's Karpenter (xkarpenter)'s namespace."
  value       = module.standalone_flow.xkarpenter_namespace
}

output "xkarpenter_version" {
  description = "Exostellar's Karpenter (xkarpenter)'s Helm chart's version."
  value       = module.standalone_flow.xkarpenter_version
}
