module "standalone_flow" {
  source = "../../modules/standalone-full"


  # Inputs for deploying EKS cluster and related resources.
  eks_cluster = "my-exostellar-cluster" # Name of the EKS cluster to be created.
  aws_region  = "us-east-2"             # AWS region to deploy cluster and all the resources in. Default is us-east-1.
  vpc_cidr    = "10.0.0.0/16"           # CIDR block for VPC to be created, for EKS.
  eks_version = "1.31"                  # EKS (Kubernetes) version. Default is 1.31.

  # Exostellar Management Server (EMS) configurations.
  ssh_key_name               = "my-exostellar-key"     # SSH key-pair name in AWS.
  ems_ami_id                 = "ami-0594e25425391e477" # EMS AMI for the selected aws_region.
  ems_instance_type          = "m5d.xlarge"            # EMS' EC2 instance type. Default is m5d.xlarge.
  ems_volume_size_gb         = 100                     # Volume size in GB. Default is 100 GB.
  ems_termination_protection = true                    # EMS' EC2 instance's termination protection. Default is true.
  profile_availability_zone  = "us-east-2a"            # Profile's availability zone. Note: Must belong to selected aws_region.

  # Xspot configurations.
  xspot_enable_hyperthreading = true # Enable hyperthreading in xspot? Default is true.
  xspot_enable_balloon        = true # Enable self-ballooning in xspot? Default is true.

  # Exostellar Karpenter (xKarpenter) configurations.
  xkarpenter_version = "v2.0.2" # xKarpenter's version. Default is v2.0.2.
}
