# Exostellar's Standalone Full Module

This deploys the full standalone flow, i.e., deploys the following in one-go:
1. EKS cluster and related resources that are suitable for EMS from the directory [infra](../../modules/infra/).
2. Exostellar's IAM resources from the directory [iam](../../modules/iam/).
3. Exostellar Management Server (EMS) and related resources from the directory [ems](../../modules/ems/).
4. Exostellar's Karpenter (xkarpenter) from the directory [karpenter](../../modules/karpenter/).

# Prerequisites

1. AWS CLI available in PATH.
2. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
3. SSH key-pair whose name must be specified in var `ssh_key_name` in [main.tf](main.tf).

# Usage

Deploy the EMS and related resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/latest) | 5.87.0 |
| [helm](https://registry.terraform.io/providers/hashicorp/helm/latest) | 2.17.0 |

## Modules

| Name | Source | Version |
|------|--------|---------|
| [iam](../../modules/iam) | ../../modules/iam | n/a |
| [ems](../../modules/ems/) | ../../modules/ems | n/a |
| [karpenter](../../modules/karpenter/) | ../../modules/karpenter | n/a |
| [infra](../../modules/infra/) | ../../modules/infra | n/a |

## Resources

No resources (or) data sources are needed apart from the `standalone_flow` module.

## Inputs

### 1. Inputs for module `infra`

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_region | AWS region for deploying resources. | `string` | `"us-east-1"` | no |
| eks_cluster | Name of the EKS cluster to be created. | `string` | `null` | yes |
| eks_version | Version of the EKS cluster to be created. | `string` | `"1.31"` | no |
| vpc_cidr | CIDR for VPC to be created. | `string` | `"10.0.0.0/16"` | no |

### 2. Inputs for module `exostellar_iam`

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|

### 3. Inputs for module `exostellar_management_server`

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| domain_name | Domain name to run Exostellar Management Server (EMS) in. Optional. | `string` | `""` | no |
| ems_instance_type | EC2 instance type for Exostellar Management Server (EMS). | `string` | `"m5d.xlarge"` | no |
| nfs_dns_name | DNS name of the NFS file system for Exostellar Management Server (EMS). | `string` | `""` | no |
| nfs_security_group_id | Security group ID that enable traffic between the NFS server and Exostellar Management Server (EMS). | `string` | `""` | no |
| profile_availability_zone | Exostellar profile's availability zone. | `string` | `""` | no |
| ems_ami_id | Exostellar Management Server (EMS)'s AMI ID for the `aws_region` specified for `infra` module input. | `string` | `"ami-03adac9e7909c6b6d"` | no |
| ssh_key_name | SSH key-pair's name for Exostellar Management Server (EMS)'s access. | `string` | `null` | yes |
| termination_protection | Enable termination protection for Exostellar Management Server (EMS)'s EC2 instance? | `bool` | `true` | no |
| ems_volume_size | Volume size (in GB) for Exostellar Management Server (EMS). | `number` | `100` | no |
| xspot_enable_balloon | Enable ballooning in Xspot? | `bool` | `true` | no |
| xspot_enable_hyperthreading | Enable hyperthreading in Xspot? | `bool` | `true` | no |

### 4. Inputs for module `xkarpenter`

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| ems_server_port | Exostellar management server (EMS)'s port to listen on. | `string` | `"5000"` | no |
| xkarpenter_helm_chart_repository | Exostellar's Karpenter (xkarpenter)'s Helm chart's repository URL. | `string` | `"oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter"` | no |
| xkarpenter_namespace | Exostellar's Karpenter (xkarpenter)'s namespace. | `string` | `"exokarpenter"` | no |
| pod_resource_limits | Pod resource requests and limits. | <pre>map(<br>  object(<br>    {<br>      cpu    = number<br>      memory = string<br>    },<br>  ),<br>) | <pre>{<br>  requests = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>  limits = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>} | no |
| xkarpenter_version | Exostellar's Karpenter (xkarpenter)'s Helm chart's version. | `string` | `"v2.0.2"` | no |

## Outputs

| Name | Description |
|------|-------------|
| vpc_id | ID of the VPC associated with the EKS cluster. |
| vpc_azs | Availability zones list of the VPC associated with the EKS cluster. |
| public_subnets | Public subnets associated with the EKS cluster. |
| private_subnets | Private subnets associated with the EKS cluster. |
| nat_gateways | NAT gateways associated with the EKS cluster. |
| internet_gateway | Internet gateway associated with the EKS cluster. |
| eks_cluster_arn | The EKS cluster's ARN. |
| eks_cluster_endpoint | The EKS cluster's endpoint. |
| eks_cluster_status | The EKS cluster's status. |
| eks_addons | The EKS cluster's add-ons list. |
| eks_cluster_security_group_id | ID of the security group associated with the EKS cluster. |
| xspot_controller_role_arn | Xspot controller's IAM role's ARN. |
| xspot_controller_instance_profile_arn | Xspot controller's IAM instance profile's ARN. |
| xspot_worker_role_arn | Xspot worker's IAM role's ARN. |
| xspot_worker_instance_profile_arn | Xspot worker's IAM instance profile's ARN. |
| ems_public_ip | Exostellar Management Server (EMS)'s public IP. |
| ems_private_ip | Exostellar Management Server (EMS)'s private IP. |
| ems_console_admin_username | Exostellar Management Server (EMS) console's admin username for login. |
| ems_console_admin_password | Exostellar Management Server (EMS) console's initial admin password for login. Change on first login. |
| eks_cluster | EKS cluster's name. |
| xkarpenter_namespace | Exostellar's Karpenter (xkarpenter)'s namespace. |
| xkarpenter_version | Exostellar's Karpenter (xkarpenter)'s Helm chart's version. |
