output "xspot_controller_role_arn" {
  description = "Xspot controller's IAM role's ARN."
  value       = module.existing_cluster_flow.xspot_controller_role_arn
}

output "xspot_controller_instance_profile_arn" {
  description = "Xspot controller's IAM instance profile's ARN."
  value       = module.existing_cluster_flow.xspot_controller_instance_profile_arn
}

output "xspot_worker_role_arn" {
  description = "Xspot worker's IAM role's ARN."
  value       = module.existing_cluster_flow.xspot_worker_role_arn
}

output "xspot_worker_instance_profile_arn" {
  description = "Xspot worker's IAM instance profile's ARN."
  value       = module.existing_cluster_flow.xspot_worker_instance_profile_arn
}

output "exostellar_management_server_public_ip" {
  description = "Exostellar Management Server (EMS)'s public IP."
  value       = module.existing_cluster_flow.exostellar_management_server_public_ip
}

output "exostellar_management_server_private_ip" {
  description = "Exostellar Management Server (EMS)'s private IP."
  value       = module.existing_cluster_flow.exostellar_management_server_private_ip
}

output "exostellar_management_server_console_admin_username" {
  description = "Exostellar Management Server (EMS) console's admin username for login."
  value       = module.existing_cluster_flow.exostellar_management_server_console_admin_username
}

output "exostellar_management_server_console_admin_password" {
  description = "Exostellar Management Server (EMS) console's initial admin password for login. Change on first login."
  value       = module.existing_cluster_flow.exostellar_management_server_console_admin_password
}

output "eks_cluster" {
  description = "EKS cluster's name."
  value       = module.existing_cluster_flow.eks_cluster
}

output "xkarpenter_namespace" {
  description = "Exostellar's Karpenter (xkarpenter)'s namespace."
  value       = module.existing_cluster_flow.xkarpenter_namespace
}

output "xkarpenter_version" {
  description = "Exostellar's Karpenter (xkarpenter)'s Helm chart's version."
  value       = module.existing_cluster_flow.xkarpenter_version
}
