module "existing_cluster_flow" {
  source = "../../modules/existing-cluster-full"


  # Inputs for deploying EKS cluster and related resources.
  eks_cluster = "my-exostellar-cluster" # Name of the existing EKS cluster.
  aws_region  = "us-east-2"             # AWS region of the EKS cluster. Default is us-east-1.
  eks_version = "1.31"                  # Kubernetes version of the existing EKS cluster. Default is 1.31.
  vpc_id      = "vpc-0b35269f469dbdc2e" # VPC ID of the EKS cluster.

  # Exostellar Management Server (EMS) configurations.
  ssh_key_name               = "my-exostellar-key"                              # SSH key-pair name in AWS.
  public_subnet_id           = "subnet-0231c16462f423e72"                       # Public subnet ID to be used with Exostellar Management Server (EMS). Note: public_subnet_id, private_subnet_id and profile_availability_zone must be of same AZ.
  profile_availability_zone  = "us-east-2a"                                     # Exostellar profile's availability zone. Note: public_subnet_id, private_subnet_id and profile_availability_zone must be of same AZ. Default is us-east-1a.
  ems_ami_id                 = "ami-0adf23061c1510b3e"                          # EMS AMI for the selected aws_region.
  ems_instance_type          = "m5d.xlarge"                                     # EMS' EC2 instance type. Default is m5d.xlarge.
  ems_volume_size_gb         = 100                                              # Volume size in GB. Default is 100 GB.
  ems_termination_protection = true                                             # EMS' EC2 instance's termination protection. Default is true.
  ems_security_group_ids     = ["sg-0d178cb07f6534981", "sg-09dfd47c24d4b36df"] # Security group IDs of existing cluster and its node group for sharing with EMS and xspot. Include any other security group IDs if required.

  # Xspot configurations.
  xspot_enable_hyperthreading = true                       # Enable hyperthreading in xspot? Default is true.
  xspot_enable_balloon        = true                       # Enable self-ballooning in xspot? Default is true.
  private_subnet_id           = "subnet-0e1a97deface1d066" # Private subnet ID to be used with xspot controllers and workers. Note: public_subnet_id, private_subnet_id and profile_availability_zone must be of same AZ.

  # Exostellar Karpenter (xKarpenter) configurations.
  xkarpenter_version = "v2.0.2" # xKarpenter's version. Default is v2.0.2.
}
