# Exostellar's Existing Cluster Full Module

This deploys the full existing cluster flow, i.e., deploys the following in one-go:
1. Exostellar's IAM resources from the directory [iam](../../modules/iam/).
2. Exostellar Management Server (EMS) and related resources from the directory [ems](../../modules/ems/).
3. Exostellar's Karpenter (xkarpenter) from the directory [karpenter](../../modules/karpenter/).

# Prerequisites

1. AWS CLI available in PATH.
2. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
3. A functional EKS cluster and configured in kube config (`~/.kube/config`).
4. SSH key-pair whose name must be specified in var `ssh_key_name` in [main.tf](main.tf).

# Usage

Deploy the EMS and related resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/latest) | 5.87.0 |
| [helm](https://registry.terraform.io/providers/hashicorp/helm/latest) | 2.17.0 |

## Modules

| Name | Source | Version |
|------|--------|---------|
| [iam](../../modules/iam) | ../../modules/iam | n/a |
| [ems](../../modules/ems/) | ../../modules/ems | n/a |
| [karpenter](../../modules/karpenter/) | ../../modules/karpenter | n/a |

## Resources

No resources (or) data sources are needed apart from the `existing_cluster_flow` module.

## Inputs

### 1. EKS Cluster Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_region | AWS region for deploying resources. | string | `"us-east-1"` | no |
| eks_cluster | Name of the EKS cluster to be created. | string | `null` | yes |
| eks_version | EKS cluster's (Kubernetes) version. | string | `null` | yes |
| vpc_id | EKS cluster's VPC ID. | string | `null` | yes |

### 2. Exostellar Management Server (EMS) Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| ssh_key_name | SSH key-pair's name for Exostellar Management Server (EMS)'s access. | string | `null` | yes |
| public_subnet_id | Public subnet ID to be used with Exostellar Management Server (EMS). Note: Public subnet ID, private subnet ID and profile's availability zone must be of same AZ. | string | `null` | yes |
| profile_availability_zone | Exostellar profile's availability zone. Note: Public subnet ID, private subnet ID and profile's availability zone must be of same AZ. | string | `us-east-1a` | no |
| ems_ami_id | Mapping of AWS region to Exostellar Management Server (EMS)'s AMI. | string | `null` | yes |
| ems_instance_type | EC2 instance type for Exostellar Management Server (EMS). | string | `"m5d.xlarge"` | no |
| ems_volume_size_gb | Volume size (in GB) for Exostellar Management Server (EMS). | number | `100` | no |
| ems_termination_protection | Enable termination protection for Exostellar Management Server (EMS)'s EC2 instance? | bool | `true` | no |
| ems_security_group_ids | EKS cluster's security group ID. | list(string) | `null` | yes |
| domain_name | Domain name to run Exostellar Management Server (EMS) in. Optional. | string | `""` | no |
| nfs_dns_name | DNS name of the NFS file system for Exostellar Management Server (EMS). | string | `""` | no |
| nfs_security_group_id | Security group ID that enable traffic between the NFS server and Exostellar Management Server (EMS). | string | `""` | no |

### 3. Xspot Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| xspot_enable_hyperthreading | Enable hyperthreading in Xspot? | bool | `true` | no |
| xspot_enable_balloon | Enable ballooning in Xspot? | bool | `true` | no |
| private_subnet_id | Private subnet ID to be used with xspot controllers and workers. Note: Public subnet ID, private subnet ID and profile's availability zone must be of same AZ. | string | `null` | yes |

### 4. Exostellar Karpenter (xKarpenter) Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| xkarpenter_version | Exostellar's Karpenter (xkarpenter)'s Helm chart's version. | string | `"v2.0.2"` | no |
| xkarpenter_helm_chart_repository | Exostellar's Karpenter (xkarpenter)'s Helm chart's repository URL. | string | `"oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter"` | no |
| xkarpenter_namespace | Exostellar's Karpenter (xkarpenter)'s namespace. | string | `"exokarpenter"` | no |
| pod_resource_limits | Pod resource requests and limits. | <pre>map(<br>  object(<br>    {<br>      cpu    = number<br>      memory = string<br>    },<br>  ),<br>) | <pre>{<br>  requests = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>  limits = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>} | no |
| exostellar_management_server_port | Exostellar management server (EMS)'s port to listen on. | string | `"5000"` | no |

## Outputs

| Name | Description |
|------|-------------|
| xspot_controller_role_arn | Xspot controller's IAM role's ARN. |
| xspot_controller_instance_profile_arn | Xspot controller's IAM instance profile's ARN. |
| xspot_worker_role_arn | Xspot worker's IAM role's ARN. |
| xspot_worker_instance_profile_arn | Xspot worker's IAM instance profile's ARN. |
| exostellar_management_server_public_ip | Exostellar Management Server (EMS)'s public IP. |
| exostellar_management_server_private_ip | Exostellar Management Server (EMS)'s private IP. |
| exostellar_management_server_console_admin_username | Exostellar Management Server (EMS) console's admin username for login. |
| exostellar_management_server_console_admin_password | Exostellar Management Server (EMS) console's initial admin password for login. Change on first login. |
| eks_cluster | EKS cluster's name. |
| xkarpenter_namespace | Exostellar's Karpenter (xkarpenter)'s namespace. |
| xkarpenter_version | Exostellar's Karpenter (xkarpenter)'s Helm chart's version. |
