# Exostellar's Xspot Module

Deploys the xspot security group.

It performs the following actions:

1. Creates security group for xspot (controllers and workers).

# Prerequisites

1. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
2. A functional EKS cluster and configured in kube config (`~/.kube/config`).

# Usage

Deploy the x-spot security group using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/6.12.0) | 6.12.0 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| aws_security_group.xspot_security_group | resource |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| eks_cluster | EKS cluster's name. It must be between 1 and 26 characters in length. | `string` | `null` | yes |
| aws_region | AWS region for deploying resources. Eg. 'us-east-1'. | `string` | `null` | yes |
| vpc_id | EKS cluster's VPC ID. | `string` | `null` | yes |
| vpc_cidr_block | EKS cluster's VPC CIDR block. | `string` | `null` | yes |
| aws_resource_prefix | Prefix to use for all AWS resources. Note: This will not add any trailing extra characters like '-'. | `string` | `""` | no |

## Outputs

| Name | Description |
|------|-------------|
| security_group_id | x-spot (controllers and workers) security group ID. |
