provider "aws" {
  region = var.aws_region
}

provider "helm" {
  kubernetes = {
    # Note: Specifying just the local configs like config_path ("~/.kube/config") and config_context (module.xio_infra.
    # eks_cluster_arn) would initialize this provider block before the xio_infra module is deployed, as they are
    # statically available, leading to inconsistent auth info, causing Kubernetes requests to fail. Hence, using the
    # auth info directly to establish dependency so it waits.
    host                   = module.xio_infra.eks_cluster_endpoint
    cluster_ca_certificate = base64decode(module.xio_infra.eks_cluster_ca_certificate)
    token                  = module.xio_infra.eks_cluster_auth_token
  }
}

provider "kubernetes" {
  # Note: Specifying just the local configs like config_path ("~/.kube/config") and config_context (module.xio_infra.
  # eks_cluster_arn) would initialize this provider block before the xio_infra module is deployed, as they are
  # statically available, leading to inconsistent auth info, causing Kubernetes requests to fail. Hence, using the auth
  # info directly to establish dependency so it waits.
  host                   = module.xio_infra.eks_cluster_endpoint
  cluster_ca_certificate = base64decode(module.xio_infra.eks_cluster_ca_certificate)
  token                  = module.xio_infra.eks_cluster_auth_token
}
