variable "eks_cluster_version" {
  description = "EKS cluster's version."
  type        = string
  # Example: "1.32".
  #
  # Note: Specifying a default value here might cause a mismatch between this and the actual EKS version. Hence, this is
  # made mandatory.
}

variable "eks_cluster_auth_mode" {
  description = "EKS cluster's authentication mode."
  type        = string
  # Example: "API" or "API_AND_CONFIG_MAP".
  #
  # Just "CONFIG_MAP" without “API” will be rejected as the `aws-auth` config map is deprecated, and also, API auth
  # (access entries) is required by the `eksconfig` module to function.
  #
  # Note: Default is not set as it is expected to fail even when the auth mode is set to "".
}
