# Precheck Module

Performs prechecks.

It performs the following actions:

1. Validates that the EKS cluster version is within the supported range [1.29, 1.30, 1.31, 1.32].
1. Validates that the EKS cluster’s authentication mode supports API access (EKS access entries).

# Prerequisites

1. A functional EKS cluster, authenticated. Refresh the EKS token (and update the `current-context` in kube config
(`~/.kube/config`)) using the following command:
    ```
    aws eks update-kubeconfig --name "<cluster>" --region "<region>"
    ```

# Usage

Run the Exostellar's precheck(s) using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [null](https://registry.terraform.io/providers/hashicorp/null/3.2.4) | 3.2.4 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| null_resource.validate_eks_version | resource |
| null_resource.validate_eks_auth_mode | resource |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| eks_cluster_version | EKS cluster's version. | `string` | `null` | yes |
| eks_cluster_auth_mode | EKS cluster's authentication mode. | `string` | `null` | yes |

## Outputs

No outputs.
