# Wait for the x-compute API to be reachable.
resource "null_resource" "wait_for_xcompute_api" {
  provisioner "local-exec" {
    command = <<EOT
      echo "Waiting for x-compute API to be reachable..."
      until curl -sk --max-time 5 https://${var.ems_public_ip}/api/v1/license >/dev/null 2>&1; do
        echo "Still waiting for x-compute API to be reachable..."
        sleep 5
      done
      echo "x-compute API is reachable!"
    EOT
  }
}


# Add the license to EMS.
#
# This performs an HTTP POST request to the x-compute license endpoint to register the license.
data "http" "add_license" {
  depends_on = [null_resource.wait_for_xcompute_api]

  url    = "https://${var.ems_public_ip}/api/v1/license"
  method = "POST"

  # Set HTTP request headers.
  request_headers = {
    # Set request content type to JSON.
    Content-Type = "application/json"
  }

  # Send the license file content as the request body.
  request_body = var.license_data

  # Skip TLS hostname verification as the Exostellar CA certificate is not available at this point in installation.
  insecure = true

  # Retry configuration for the HTTP request.
  retry {
    attempts     = 10    # Number of retries.
    min_delay_ms = 5000  # Exponential backoff between retries, starting at 5s.
    max_delay_ms = 30000 # Exponential backoff between retries, up to 30s.
  }
}
