# Exostellar Management Server (EMS) License Module

Adds license to Exostellar Management Server (EMS).

It performs the following actions:

1. Waits for the x-compute API to be reachable.
1. Adds the license to EMS.

# Prerequisites

1. Exostellar Management Server (EMS) should be up and running.

# Usage

Deploy the Exostellar license resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [http](https://registry.terraform.io/providers/hashicorp/http/3.5.0) | 3.5.0 |
| [null](https://registry.terraform.io/providers/hashicorp/null/3.2.4) | 3.2.4 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| null_resource.add_license | resource |

## Inputs


| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| ems_public_ip | Exostellar Management Server (EMS)'s public IP address. | string | `null` | yes |
| license_data | The Exostellar's license data in JSON format. | string | `null` | yes |

## Outputs

No outputs.
