# Exostellar's Karpenter (xkarpenter) Module

Deploys Exostellar's Karpenter (xKarpenter) and related resources.

It performs the following actions:

1. Creates Exostellar's Karpenter (xkarpenter) namespace
1. Creates IRSA for Exostellar's Karpenter (xkarpenter).
1. Attaches Karpenter policy to IAM role.
1. Creates IRSA for Exostellar's xnode-controller.
1. Attaches exo-node-controller policy to the IAM role.
1. Deploys the Exostellar's Karpenter (xkarpenter)'s Helm chart.
1. Deploys the Exostellar's Karpenter (xkarpenter) resources (default ExoNodeClass and ExoNodePool) Helm chart.

# Prerequisites

1. A functional EKS cluster. Refresh the EKS token and update the `current-context` in kube config (`~/.kube/config`) using the following command:
    ```
    aws eks update-kubeconfig --name "<cluster>" --region "<region>"
    ```
    > It is recommended to use the [infra](../infra/) module to create the EKS cluster.
2. IAM module deployed using [here](../iam/). The xspot controller and worker IAM instance profile ARNs are required as
   inputs to current module.
3. EMS module deployed using [here](../ems/). The Exostellar Management Server (EMS)'s private IP address is required as
   input to current module.

# Usage

Deploy the Exostellar's Karpenter (xkarpenter) using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/6.12.0) | 6.12.0 |
| [helm](https://registry.terraform.io/providers/hashicorp/helm/3.0.2) | 3.0.2 |
| [kubernetes](https://registry.terraform.io/providers/hashicorp/kubernetes/2.38.0) | 2.38.0 |
| [null](https://registry.terraform.io/providers/hashicorp/null/3.2.4) | 3.2.4 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| helm_release.xkarpenter | resource |
| helm_release.xkarpenter_resources | resource |
| kubernetes_namespace.xkarpenter_namespace | resource |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_resource_prefix | Prefix to use for all AWS resources. Note: This will not add any trailing extra characters like '-'. | `string` | `""` | no |
| eks_cluster | EKS cluster's name. It must be between 1 and 26 characters in length. | `string` | `null` | yes |
| eks_cluster_oidc_issuer | EKS cluster's OIDC issuer URL. | `string` | `null` | yes |
| eks_cluster_oidc_provider_arn | EKS cluster's OIDC provider ARN. | `string` | `null` | yes |
| eks_cluster_private_subnet_ids | List of private subnet IDs associated with the EKS cluster. | `list(string)` | `null` | yes |
| enable_infrastructure_optimizer | Enable Infrastructure Optimizer (IO) for xspot? | `bool` | `true` | no |
| enable_workload_optimizer | Enable Workload Optimizer (WO) for xspot? | `bool` | `true` | no |
| exostellar_management_server_private_ip | Exostellar management server (EMS)'s private IP address. | `string` | `null` | yes |
| guest_kernel_version | Guest kernel version for xspot nodes. | `string` | `"5.15.185"` |
| k8s_node_image_name | Kubernetes node image name. Eg. `"k8s-132"` | `string` | `null` | yes |
| namespace | Exostellar's Karpenter (xkarpenter)'s namespace. | `string` | `"exokarpenter"` | no |
| pod_resources | Pod resource requests and limits. | <pre>map(<br>  object(<br>    {<br>      cpu    = number<br>      memory = string<br>    },<br>  ),<br>) | <pre>{<br>  requests = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>  limits = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>} | no |
| xcompute_node_security_groups | List of security groups to attach to x-compute nodes. | `list(string)` | `null` | yes |
| xkarpenter_helm_chart_repository | Exostellar's Karpenter (xkarpenter)'s Helm chart's repository URL. | `string` | `"oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter"` | no |
| xkarpenter_resources_helm_chart_repository | Exostellar's Karpenter (xkarpenter)'s resources (ExoNodeClass and ExoNodePool) Helm chart's repository URL. | string | `"oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter-resources"` | no |
| xkarpenter_version | Exostellar's Karpenter (xkarpenter)'s Helm chart's version. Note: To keep xKarpenter and xKarpenter Resources compatible, same version is used with both charts. | `string` | `"v2.0.6"` | no |
| xspot_controller_instance_profile_arn | Xspot controller's instance-profile's ARN | `string` | `null` | yes |
| xspot_enable_balloon | Enable ballooning in Xspot? | `bool` | `true` | no |
| xspot_enable_hyperthreading | Enable hyperthreading in Xspot? | `bool` | `true` | no |
| xspot_version | Xspot (controller and worker) version to use. | `string` | `"xspot-3.4.0"` | no |
| xspot_worker_instance_profile_arn | Xspot worker's instance-profile's ARN | `string` | `null` | yes |

## Outputs

No outputs.
