variable "aws_region" {
  description = "AWS region for deploying resources."
  type        = string
  default     = "us-east-1"
}

variable "vpc_cidr" {
  description = "CIDR for VPC to be created."
  type        = string
  default     = "10.0.0.0/16"
}

variable "eks_cluster" {
  description = "Name of the EKS cluster to be created. It must be between 1 and 26 characters in length."
  type        = string

  # EKS cluster name length validation. It must be between 1 and 26 characters.
  validation {
    condition = (
      length(var.eks_cluster) > 0 &&
      length(var.eks_cluster) <= 26
    )
    error_message = <<EOT
EKS cluster name's length must be between 1 and 26 characters in the Exostellar modules. As the EKS cluster name will be
prefixed to all Exostellar resources, due to the length limitations on a few of the resources, the EKS cluster name must
be at most 26 characters long.
EOT
  }
}

variable "eks_version" {
  description = "Version of the EKS cluster to be created."
  type        = string
  default     = "1.32"
}

variable "eks_node_group_desired_size" {
  description = "Desired size of the EKS node group."
  type        = number
  default     = 3
}
