output "vpc_id" {
  description = "ID of the VPC associated with the EKS cluster."
  value       = module.vpc.vpc_id
}

output "public_subnets" {
  description = "Public subnets associated with the EKS cluster."
  value       = module.vpc.public_subnets
}

output "private_subnets" {
  description = "Private subnets associated with the EKS cluster."
  value       = module.vpc.private_subnets
}

output "eks_cluster_endpoint" {
  description = "The EKS cluster's endpoint."
  value       = module.eks.cluster_endpoint
}

output "eks_cluster_ca_certificate" {
  description = "The EKS cluster's certificate auuthority."
  value       = module.eks.cluster_certificate_authority_data
}

output "eks_cluster_auth_token" {
  description = "The EKS cluster's auth token."
  value       = data.aws_eks_cluster_auth.eks_cluster_auth.token
  sensitive   = true
}

output "eks_cluster_security_group_id" {
  description = "ID of the security group associated with the EKS cluster."
  value       = module.eks.cluster_security_group_id
}

output "eks_cluster_primary_security_group_id" {
  description = "ID of the primary security group associated with the EKS cluster."
  value       = module.eks.cluster_primary_security_group_id
}

output "eks_cluster_additional_security_group_ids" {
  description = "Additional security groups associated with the EKS cluster."
  value       = [module.eks.node_security_group_id]
}

output "eks_cluster_oidc_issuer" {
  description = "The EKS cluster's OIDC issuer URL."
  value       = module.eks.cluster_oidc_issuer_url
}

output "eks_cluster_oidc_thumbprint" {
  description = "The EKS cluster's OIDC thumbprint."
  value       = data.tls_certificate.eks_cluster_oidc.certificates[0].sha1_fingerprint
}
