# Exostellar's Infra Module

Deploys EKS cluster and related resources.

It performs the following actions:

1. Reads the available availability zones in the region.
1. Creates VPC and other networking resources for EKS cluster.
1. Creates EKS cluster with managed node group.
1. Creates IRSA setup for EBS CSI driver.
1. Reads the EKS cluster's auth info.
1. Reads the EKS cluster's TLS certificate details.

> [!WARNING] 
> The standalone flow is not up-to-date with current changes. Work-in-progress.

# Prerequisites

1. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).

# Usage

Deploy the EMS and related resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/6.12.0) | 6.12.0 |
| [cloudinit](https://registry.terraform.io/providers/hashicorp/cloudinit/2.3.7) | 2.3.7 |
| [null](https://registry.terraform.io/providers/hashicorp/null/3.2.4) | 3.2.4 |
| [time](https://registry.terraform.io/providers/hashicorp/time/0.13.1) | 0.13.1 |
| [tls](https://registry.terraform.io/providers/hashicorp/tls/4.1.0) | 4.1.0 |


## Modules

| Name | Source | Version |
|------|--------|---------|
| terraform-aws-modules/vpc/aws | [terraform-aws-modules/vpc/aws](https://registry.terraform.io/modules/terraform-aws-modules/vpc/aws/6.0.1) | 6.0.1 |
| terraform-aws-modules/eks/aws | [terraform-aws-modules/eks/aws](https://registry.terraform.io/modules/terraform-aws-modules/eks/aws/21.1.5) | 21.1.5 |
| terraform-aws-modules/iam/aws//modules/iam-role-for-service-accounts | [terraform-aws-modules/iam/aws//modules/iam-role-for-service-accounts](https://registry.terraform.io/modules/terraform-aws-modules/iam/aws/6.2.1/submodules/iam-role-for-service-accounts) | 6.2.1 |

## Resources

| Name | Type |
|------|------|
| aws_availability_zones.available | data source |
| aws_eks_cluster_auth.eks_cluster_auth | resource |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_region | AWS region for deploying resources. | `string` | `"us-east-1"` | no |
| vpc_cidr | CIDR for VPC to be created. | `string` | `"10.0.0.0/16"` | no |
| eks_cluster | Name of the EKS cluster to be created. It must be between 1 and 26 characters in length. | `string` | `null` | yes |
| eks_version | Version of the EKS cluster to be created. | `string` | `"1.32"` | no |
| eks_node_group_desired_size | Desired size of the EKS node group. | `number` | `3` | no |

## Outputs

| Name | Description |
|------|-------------|
| eks_cluster_auth_token | The EKS cluster's auth token. |
| eks_cluster_ca_certificate | The EKS cluster's certificate auuthority. |
| eks_cluster_endpoint | The EKS cluster's endpoint. |
| eks_cluster_primary_security_group_id | ID of the primary security group associated with the EKS cluster. |
| eks_cluster_security_group_id | ID of the security group associated with the EKS cluster. |
| private_subnets | Private subnets associated with the EKS cluster. |
| public_subnets | Public subnets associated with the EKS cluster. |
| vpc_id | ID of the VPC associated with the EKS cluster. |
