variable "aws_region" {
  description = "AWS region for deploying resources. Eg. 'us-east-1'."
  type        = string
}

variable "eks_cluster" {
  description = "EKS cluster's name. It must be between 1 and 26 characters in length."
  type        = string

  # EKS cluster name length validation. It must be between 1 and 26 characters.
  validation {
    condition = (
      length(var.eks_cluster) > 0 &&
      length(var.eks_cluster) <= 26
    )
    error_message = <<EOT
EKS cluster name's length must be between 1 and 26 characters in the Exostellar modules. As the EKS cluster name will be
prefixed to all Exostellar resources, due to the length limitations on a few of the resources, the EKS cluster name must
be at most 26 characters long.
EOT
  }
}

variable "aws_resource_prefix" {
  description = "Prefix to use for all AWS resources. Note: This will not add any trailing extra characters like '-'."
  type        = string
  default     = ""
}

variable "permissions_boundary_arn" {
  description = "Optional ARN of an IAM policy to use as a permissions boundary for all IAM roles created by this module."
  type        = string
  default     = null
}
