# Exostellar's IAM Module

Deploys the Exostellar's IAM resources.

It performs the following actions:

1. Reads the IAM policy document for EC2 instance assume role.
1. Reads managed IAM policy AmazonEC2ContainerRegistryReadOnly.
1. Reads managed IAM policy AmazonSSMManagedInstanceCore.
1. Reads managed IAM policy AmazonEKS_CNI_Policy.
1. Reads managed IAM policy AmazonEKSWorkerNodePolicy.
1. Reads managed IAM policy AmazonEBSCSIDriverPolicy.
1. Creates IAM Role for xspot controller.
1. Creates IAM Policy for xspot controller.
1. Creates IAM Instance Profile for xspot controller.
1. Creates IAM Role for xspot worker.
1. Creates IAM Policy for xspot worker.
1. Creates IAM Instance Profile for xspot worker.
1. Attaches managed IAM policy AmazonEC2ContainerRegistryReadOnly to xspot worker.
1. Attaches managed IAM policy AmazonSSMManagedInstanceCore to xspot worker.
1. Attaches managed IAM policy AmazonEKS_CNI_Policy to xspot worker.
1. Attaches managed IAM policy AmazonEKSWorkerNodePolicy to xspot worker.
1. Attaches managed IAM policy AmazonEBSCSIDriverPolicy to xspot worker.

# Prerequisites

1. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
2. A functional EKS cluster and configured in kube config (`~/.kube/config`).
    > Recommended to use the [infra](../infra/) module to create the EKS cluster.

# Usage

Create the IAM module with inputs, similar to the example: [exostellar_iam](../../examples/iam/README.md).

Deploy the Exostellar IAM resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/6.12.0) | 6.12.0 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| aws_iam_policy_document.instance_assume_role_policy | data source |
| aws_iam_policy.managed_ec2_container_registry_read_only_policy | data source |
| aws_iam_policy.managed_amazon_ssm_managed_instance_core_policy | data source |
| aws_iam_policy.managed_eks_cni_policy | data source |
| aws_iam_policy.managed_eks_worker_node_policy | data source |
| aws_iam_policy.managed_ebs_csi_driver_policy | data source |
| aws_iam_role.xspot_controller_role | resource |
| aws_iam_role_policy.xspot_controller_role_policy | resource |
| aws_iam_instance_profile.xspot_controller_instance_profile | resource |
| aws_iam_role.xspot_worker_role | resource |
| aws_iam_role_policy.xspot_worker_role_policy | resource |
| aws_iam_instance_profile.xspot_worker_instance_profile | resource |
| aws_iam_role_policy_attachment.xspot_worker_role_managed_ec2_container_registry_read_only_policy_attachment | resource |
| aws_iam_role_policy_attachment.xspot_worker_role_managed_amazon_ssm_managed_instance_core_policy_attachment | resource |
| aws_iam_role_policy_attachment.xspot_worker_role_managed_eks_cni_policy_attachment | resource |
| aws_iam_role_policy_attachment.xspot_worker_role_managed_eks_worker_node_policy_attachment | resource |
| aws_iam_role_policy_attachment.xspot_worker_role_managed_ebs_csi_driver_policy_attachment | resource |

## Inputs


| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_region | AWS region for deploying resources. Eg. 'us-east-1'. | `string` | `null` | yes |
| eks_cluster | EKS cluster's name. It must be between 1 and 26 characters in length. | `string` | `null` | yes |
| aws_resource_prefix | Prefix to use for all AWS resources. Note: This will not add any trailing extra characters like '-'. | `string` | `""` | no |
| permissions_boundary_arn | ARN of an IAM policy to set as a permissions boundary on the IAM roles created by this module. | `string` | `null` | no |

## Outputs

| Name | Description |
|------|-------------|
| xspot_controller_role_arn | Xspot controller's IAM role's ARN. |
| xspot_controller_instance_profile_arn | Xspot controller's IAM instance profile's ARN. |
| xspot_worker_role_arn | Xspot worker's IAM role's ARN. |
| xspot_worker_instance_profile_arn | Xspot worker's IAM instance profile's ARN. |
