# Exostellar's EBS CSI Driver IRSA Module

Deploys IRSA for the EBS CSI driver.

It performs the following actions:

1. Create an IAM Role for Service Account (IRSA) for the Amazon EBS CSI driver.

# Prerequisites

1. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
2. A functional EKS cluster (with configuration in the kube config `~/.kube/config`), with EBS CSI driver preinstalled
(either add-on or Helm chart).

# Usage

Deploy the IAM role for IRSA using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/6.12.0) | 6.12.0 |

## Modules

| Name | Source | Version |
|------|--------|---------|
| terraform-aws-modules/iam/aws//modules/iam-role-for-service-accounts | [terraform-aws-modules/iam/aws//modules/iam-role-for-service-accounts](https://registry.terraform.io/modules/terraform-aws-modules/iam/aws/6.2.1/submodules/iam-role-for-service-accounts) | 6.2.1 |

## Resources

| Name | Type |
|------|------|

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_region | AWS region for deploying resources. | `string` | `"us-east-1"` | no |
| eks_cluster | EKS cluster's name. It must be between 1 and 26 characters in length. | `string` | `null` | yes |
| eks_cluster_oidc_provider_arn | EKS cluster's OIDC provider ARN. | `string` | `null` | yes |

## Outputs

| Name | Description |
|------|-------------|
