provider "aws" {
  region = var.aws_region
}

provider "helm" {
  kubernetes = {
    # Note: Specifying just the local configs like config_path ("~/.kube/config") and config_context
    # ("arn:aws:eks:<region>:<account-id>:cluster/<cluster>") would initialize this provider block before the
    # `update-kubeconfig` refreshes the EKS token and configures current-context, as they are statically available,
    # leading to inconsistent auth info, causing Kubernetes requests to fail. Hence, using the auth info directly to
    # establish dependency so it waits.
    host                   = data.aws_eks_cluster.eks_cluster.endpoint
    cluster_ca_certificate = base64decode(data.aws_eks_cluster.eks_cluster.certificate_authority[0].data)
    token                  = data.aws_eks_cluster_auth.eks_cluster_auth.token
  }
}

provider "kubernetes" {
  # Note: Specifying just the local configs like config_path ("~/.kube/config") and config_context
  # ("arn:aws:eks:<region>:<account-id>:cluster/<cluster>") would initialize this provider block before the
  # `update-kubeconfig` refreshes the EKS token and configures current-context, as they are statically available,
  # leading to inconsistent auth info, causing Kubernetes requests to fail. Hence, using the auth info directly to
  # establish dependency so it waits.
  host                   = data.aws_eks_cluster.eks_cluster.endpoint
  cluster_ca_certificate = base64decode(data.aws_eks_cluster.eks_cluster.certificate_authority[0].data)
  token                  = data.aws_eks_cluster_auth.eks_cluster_auth.token
}
