# Exostellar's EMS Module

Deploys the Exostellar Management Server (EMS) and related resources.

It performs the following actions:

1. Reads the subnet based on its ID.
1. Reads the IAM policy document for EC2 instance assume role.
1. Reads the AWS-managed IAM policy for SSM.
1. Creates a security Group for Exostellar Management Server (EMS).
1. Creates IAM Role for Exostellar Management Server (EMS).
1. Creates IAM Policy for Exostellar Management Server (EMS).
1. Attaches the SSM policy to the EMS role, only if SSM flag is enabled.
1. Creates IAM Instance Profile for Exostellar Management Server (EMS).
1. Creates the Exostellar Management Server (EMS) EC2 instance.

# Prerequisites

1. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
2. A functional EKS cluster and configured in kube config (`~/.kube/config`).
    > Recommended to use the [infra](../infra/) module to create the EKS cluster.
3. Optional SSH key-pair whose name can be specified in var `ssh_key_name` in [main.tf](main.tf).
4. IAM module from [here](../iam/).

# Usage

Create the EMS module with inputs, similar to the example: [ems](../../examples/ems/README.md).

Deploy the EMS and related resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/6.12.0) | 6.12.0 |
| [helm](https://registry.terraform.io/providers/hashicorp/helm/3.0.2) | 3.0.2 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| aws_subnet.cluster_subnet | data source |
| aws_iam_policy_document.instance_assume_role_policy | data source |
| aws_iam_policy.managed_amazon_ssm_managed_instance_core_policy | data source |
| aws_security_group.exostellar_management_server | resource |
| aws_iam_role.exostellar_management_server | resource |
| aws_iam_role_policy.exostellar_management_server | resource |
| aws_iam_role_policy_attachment.exostellar_management_server_role_managed_amazon_ssm_managed_instance_core | resource |
| aws_iam_instance_profile.exostellar_management_server | resource |
| aws_instance.exostellar_management_server | resource |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| aws_region | AWS region for deploying resources. Eg. 'us-east-1'. | `string` | `null` | yes |
| eks_cluster | EKS cluster's name. It must be between 1 and 26 characters in length. | `string` | `null` | yes |
| vpc_id | EKS cluster's VPC ID. | `string` | `null` | yes |
| vpc_cidr_block | EKS cluster's VPC CIDR block. | `string` | `null` | yes |
| subnet_id | EKS cluster's subnet ID. | `string` | `null` | yes |
| is_subnet_public | Is EKS cluster's subnet public? | `bool` | `true` | no |
| domain_name | Domain name to run Exostellar Management Server (EMS) in. Optional. | `string` | `""` | no |
| shared_security_group_ids | Share security groups' IDs to attach to Exostellar Management Server (EMS). Optional. | `list(string)` | `[]` | no |
| instance_type | EC2 instance type for Exostellar Management Server (EMS). | `string` | `"m5d.xlarge"` | no |
| volume_size | Exostellar Management Server (EMS) instance's root volume size (in GB). | `number` | `100` | no |
| volume_delete_on_termination | Delete the Exostellar Management Server (EMS) instance's root volume on termination of instance? | `bool` | `true` | no |
| encrypt_volume | Encrypt the Exostellar Management Server (EMS) instance's root volume? | `bool` | `false` | no |
| volume_type | Exostellar Management Server (EMS) instance's root volume type. Valid options: standard, gp2, gp3, io1, io2, sc1, and st1. | `string` | `"gp2"` | no |
| ssh_key_name | SSH key-pair's name in AWS for Exostellar Management Server (EMS)'s access. If ssm_enabled is set to true, this will be skipped. | `string` | `null` | no |
| termination_protection | Enable termination protection for Exostellar Management Server (EMS)'s EC2 instance? | `bool` | `true` | no |
| region_ami_map | Mapping of AWS region to Exostellar Management Server (EMS)'s AMI. | `map(string)` | `null` | yes |
| nfs_dns_name | DNS name of the NFS file system for Exostellar Management Server (EMS). | `string` | `""` | no |
| nfs_security_group_id | Security group ID that enable traffic between the NFS server and Exostellar Management Server (EMS). | `string` | `""` | no |
| xspot_controller_subnet_id | Xspot controller's subnet ID. | `string` | `null` | yes |
| xspot_controller_instance_profile_arn | Xspot controller's instance profile's ARN | `string` | `null` | yes |
| xspot_worker_subnet_id | Xspot worker's subnet ID. | `string` | `null` | yes |
| xspot_worker_instance_profile_arn | Xspot worker's instance profile's ARN | `string` | `null` | yes |
| xspot_enable_hyperthreading | Enable hyperthreading in Xspot? | `bool` | `true` | no |
| xspot_enable_balloon | Enable ballooning in Xspot? | `bool` | `true` | no |
| profile_az | Exostellar profile's availability zone. | `string` | `""` | no |
| k8s_node_image_name | Kubernetes node image name. Eg. `"k8s-132"` | `string` | `null` | yes |
| ssm_enabled | Enable AWS Systems Manager (SSM) for Exostellar Management Server (EMS)? | `false` | `bool` | no |
| xspot_security_group_id | x-spot (controllers and workers) security group ID | `string` | `""` | no |
| aws_resource_prefix | Prefix to use for all AWS resources. Note: This will not add any trailing extra characters like '-'. | `string` | `""` | no |
| permissions_boundary_arn | ARN of an IAM policy to set as a permissions boundary on the EMS IAM role created by this module. | `string` | `null` | no |

## Outputs

| Name | Description |
|------|-------------|
| exostellar_management_server_public_ip | Exostellar Management Server (EMS)'s public IP. |
| exostellar_management_server_private_ip | Exostellar Management Server (EMS)'s private IP. |
| exostellar_management_server_console_admin_username | Exostellar Management Server (EMS) console's admin username for login. |
| exostellar_management_server_console_admin_password | Exostellar Management Server (EMS) console's initial admin password for login. Change on first login. |
