##########################
### EKS Cluster Inputs ###
##########################

variable "eks_cluster" {
  description = "EKS cluster's name. It must be between 1 and 26 characters in length."
  type        = string

  # EKS cluster name length validation. It must be between 1 and 26 characters.
  validation {
    condition = (
      length(var.eks_cluster) > 0 &&
      length(var.eks_cluster) <= 26
    )
    error_message = <<EOT
EKS cluster name's length must be between 1 and 26 characters in the Exostellar modules. As the EKS cluster name will be
prefixed to all Exostellar resources, due to the length limitations on a few of the resources, the EKS cluster name must
be at most 26 characters long.
EOT
  }
}

variable "eks_cluster_oidc_issuer" {
  description = "EKS cluster's OIDC issuer URL."
  type        = string
}

variable "eks_cluster_oidc_thumbprint" {
  description = "EKS cluster's OIDC thumbprint."
  type        = string
}

####################
### Xspot Inputs ###
####################

variable "xspot_controller_role_arn" {
  description = "Xspot controller's IAM role ARN."
  type        = string
}

variable "xspot_worker_role_arn" {
  description = "Xspot worker's IAM role ARN."
  type        = string
}

##################
### CNI Inputs ###
##################

variable "exo_cni_chart_repository" {
  description = "Exostellar's CNI chart's repository URL."
  type        = string
  default     = "oci://public.ecr.aws/u8h5n6o4/exostellar-cni/exo-aws-vpc-cni"
}

variable "exo_cni_chart_version" {
  description = "Exostellar's CNI chart's version."
  type        = string
  default     = "1.20.0"
}

variable "exo_cni_chart_namespace" {
  description = "Exostellar's CNI chart's namespace."
  type        = string
  default     = "kube-system"
}

##################
### CSI Inputs ###
##################

variable "exo_csi_chart_repository" {
  description = "Exostellar's CSI chart's repository URL."
  type        = string
  default     = "oci://public.ecr.aws/u8h5n6o4/exostellar-csi/exo-aws-ebs-csi-driver"
}

variable "exo_csi_chart_version" {
  description = "Exostellar's CSI chart's version."
  type        = string
  default     = "1.46.0"
}

variable "exo_csi_chart_namespace" {
  description = "Exostellar's CSI chart's namespace."
  type        = string
  default     = "kube-system"
}
