# Add EKS access entry for xspot controller.
resource "aws_eks_access_entry" "xspot_controller" {
  cluster_name  = var.eks_cluster
  principal_arn = var.xspot_controller_role_arn
  type          = "STANDARD"
}

# Associate EKS admin view policy with xspot controller.
resource "aws_eks_access_policy_association" "xspot_controller_admin_view_policy" {
  cluster_name  = var.eks_cluster
  policy_arn    = "arn:aws:eks::aws:cluster-access-policy/AmazonEKSAdminViewPolicy"
  principal_arn = aws_eks_access_entry.xspot_controller.principal_arn

  access_scope {
    type = "cluster"
  }
}

# Add EKS access entry for xspot worker.
resource "aws_eks_access_entry" "xspot_worker" {
  cluster_name  = var.eks_cluster
  principal_arn = var.xspot_worker_role_arn
  type          = "STANDARD"
}

# Associate EKS admin policy with xspot worker.
resource "aws_eks_access_policy_association" "xspot_worker_admin_policy" {
  cluster_name  = var.eks_cluster
  policy_arn    = "arn:aws:eks::aws:cluster-access-policy/AmazonEKSClusterAdminPolicy"
  principal_arn = aws_eks_access_entry.xspot_worker.principal_arn

  access_scope {
    type = "cluster"
  }
}

# Create OIDC provider for the EKS cluster.
resource "aws_iam_openid_connect_provider" "eks_cluster_oidc_provider" {
  url             = var.eks_cluster_oidc_issuer
  client_id_list  = ["sts.amazonaws.com"]
  thumbprint_list = [var.eks_cluster_oidc_thumbprint]
}

# Deploy Exostellar CNI's Helm chart.
resource "helm_release" "exo_cni" {
  name      = "exo-aws-node"
  namespace = var.exo_cni_chart_namespace
  chart     = var.exo_cni_chart_repository
  version   = var.exo_cni_chart_version

  # Increase timeout from 300s to 600s as there might be a delay in pulling the image(s) and Helm chart from ECR,
  # Kubernetes API in EKS cluster, etc.
  timeout = 600
}

# Deploy Exostellar CSI's Helm chart.
resource "helm_release" "exo_csi" {
  name      = "exo-aws-ebs-csi-driver"
  namespace = var.exo_csi_chart_namespace
  chart     = var.exo_csi_chart_repository
  version   = var.exo_csi_chart_version

  # Increase timeout from 300s to 600s as there might be a delay in pulling the image(s) and Helm chart from ECR,
  # Kubernetes API in EKS cluster, etc.
  timeout = 600

  # Values to pass to the Helm chart as YAML.
  values = [
    yamlencode({
      nodeComponentOnly = true
    })
  ]
}
