# Exostellar's Module for Configuring EKS Cluster

Configures the EKS cluster according to Exostellar’s standard setup.

It performs the following actions:

1. Adds EKS access entry for xspot controller.
1. Associates EKS admin view policy with xspot controller.
1. Adds EKS access entry for xspot worker.
1. Associates EKS admin policy with xspot worker.
1. Creates OIDC provider for the EKS cluster.
1. Deploys Exostellar CNI's Helm chart.
1. Deploys Exostellar CSI's Helm chart.

# Prerequisites

1. Sign in to AWS CLI. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
2. A functional EKS cluster and configured in kube config (`~/.kube/config`).

# Usage

This is used by the standalone flow and the existing cluster flow internally. But if it has to be deployed individually,
the following are the steps.

To deploy this module, i.e., configure the EKS cluster, do the following:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

To destroy this module, i.e., undo the configuration on the EKS cluster, do the following:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/6.12.0) | 6.12.0 |
| [helm](https://registry.terraform.io/providers/hashicorp/helm/3.0.2) | 3.0.2 |

## Modules

No modules imported.

## Resources

| Name | Type |
|------|------|
| aws_eks_access_entry.xspot_controller | resource |
| aws_eks_access_policy_association.xspot_controller_admin_view_policy | resource |
| aws_eks_access_entry.xspot_worker | resource |
| aws_eks_access_policy_association.xspot_worker_admin_policy | resource |
| aws_iam_openid_connect_provider.eks_cluster_oidc_provider | resource |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| eks_cluster | EKS cluster's name. It must be between 1 and 26 characters in length. | string | `null` | yes |
| eks_cluster_oidc_issuer | EKS cluster's OIDC issuer URL. | `string` | `null | yes |
| eks_cluster_oidc_thumbprint | EKS cluster's OIDC thumbprint. | `string` | `null | yes |
| xspot_controller_role_arn | Xspot controller's IAM role ARN. | `string` | `null` | yes |
| xspot_worker_role_arn | Xspot worker's IAM role ARN. | `string` | `null` | yes |
| exo_cni_chart_repository | Exostellar's CNI chart's repository URL. | `string` | `"oci://public.ecr.aws/u8h5n6o4/exostellar-cni/exo-aws-vpc-cni"` | no |
| exo_cni_chart_version | Exostellar's CNI chart's version. | `string` | `"1.20.0"` | no |
| exo_cni_chart_namespace | Exostellar's CNI chart's namespace. | `string` | `"kube-system"` | no |
| exo_csi_chart_repository | Exostellar's CSI chart's repository URL. | `string` | `"oci://public.ecr.aws/u8h5n6o4/exostellar-csi/exo-aws-ebs-csi-driver"` | no |
| exo_csi_chart_version | Exostellar's CSI chart's version. | `string` | `"1.46.0"` | no |
| exo_csi_chart_namespace | Exostellar's CSI chart's namespace. | `string` | `"kube-system"` | no |

## Outputs

| Name | Description |
|------|-------------|
| eks_cluster_oidc_provider_arn | EKS cluster's OIDC provider ARN. |
