# Exostellar's Standalone Flow Module

Deploys an EKS cluster and sets up the Exostellar environment on it.

It performs the following actions:

1. Deploys EKS cluster and related resources.
1. Updates kubeconfig to use the specified EKS cluster.
1. Deploys the Exostellar's IAM resources.
1. Deploys the Exostellar Management Server (EMS) and related resources.
1. Configures the EKS cluster according to Exostellar’s standard setup.
1. Adds license to Exostellar Management Server (EMS).
1. Deploys Exostellar's Karpenter (xKarpenter) and related resources.

> [!WARNING] 
> The standalone flow is not up-to-date with current changes. Work-in-progress.

# Prerequisites

1. The following binaries must be available in the local environment:
    1. `aws` CLI. Refer to [this page](https://docs.aws.amazon.com/cli/latest/userguide/getting-started-install.html)
    for details on installing it.
2. AWS CLI login. Ref. to the [doc](https://docs.aws.amazon.com/signin/latest/userguide/command-line-sign-in.html).
3. Optional SSH key-pair whose name can be specified in var `ssh_key_name` in [main.tf](main.tf).

# Usage

Deploy the EMS and related resources using:

```bash
terraform init
terraform plan -input=false
terraform apply -auto-approve
```

When you don't want them anymore, destroy using:

```bash
terraform destroy -auto-approve -refresh=true
```

## Requirements

| Name | Version |
|------|---------|
| [terraform](https://github.com/hashicorp/terraform) | ~> 1.8 |

## Providers

| Name | Version |
|------|---------|
| [aws](https://registry.terraform.io/providers/hashicorp/aws/6.12.0) | 6.12.0 |
| [cloudinit](https://registry.terraform.io/providers/hashicorp/cloudinit/2.3.7) | 2.3.7 |
| [helm](https://registry.terraform.io/providers/hashicorp/helm/3.0.2) | 3.0.2 |
| [http](https://registry.terraform.io/providers/hashicorp/http/3.5.0) | 3.5.0 |
| [kubernetes](https://registry.terraform.io/providers/hashicorp/kubernetes/2.38.0) | 2.38.0 |
| [null](https://registry.terraform.io/providers/hashicorp/null/3.2.4) | 3.2.4 |
| [time](https://registry.terraform.io/providers/hashicorp/time/0.13.1) | 0.13.1 |
| [tls](https://registry.terraform.io/providers/hashicorp/tls/4.1.0) | 4.1.0 |

## Modules

| Name | Source | Version |
|------|--------|---------|
| [iam](../../modules/iam) | ../../modules/iam | n/a |
| [ems](../../modules/ems/) | ../../modules/ems | n/a |
| [karpenter](../../modules/karpenter/) | ../../modules/karpenter | n/a |
| [infra](../../modules/infra/) | ../../modules/infra | n/a |

## Resources

No resources (or) data sources are needed apart from the `standalone_flow` module.

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| allow_xspot_worker_inbound_traffic | Enable inbound traffic to x-spot worker? | `bool` | `true` | no |
| aws_region | AWS region for deploying resources. | `string` | `"us-east-1"` | no |
| aws_resource_prefix | Prefix to use for all AWS resources. Note: This will not add any trailing extra characters like '-'. | 
| domain_name | Domain name to run Exostellar Management Server (EMS) in. Optional. | `string` | `""` | no |
| eks_cluster | Name of the EKS cluster to be created. It must be between 1 and 26 characters in length. | `string` | `null` | yes |
| eks_node_group_desired_size | Desired size of the default EKS node group. | `number` | `3` | no |
| eks_version | Version of the EKS cluster to be created. | `string` | `"1.32"` | no |
| ems_ami_id | EMS AMI for the selected aws_region. | `string` | `null` | yes |
| ems_instance_type | EC2 instance type for Exostellar Management Server (EMS). | `string` | `"m5d.xlarge"` | no |
| ems_termination_protection | Enable termination protection for Exostellar Management Server (EMS)'s EC2 instance? | `bool` | `true` | no |
| ems_volume_delete_on_termination | Delete the Exostellar Management Server (EMS) instance's root volume on termination of instance? | `bool` | `true` |
| ems_volume_encryption | Encrypt the Exostellar Management Server (EMS) instance's root volume? | `bool` | `false` | no |
| ems_volume_size_gb | Exostellar Management Server (EMS) instance's root volume size (in GB) | `number` | `100` | no |
| ems_volume_type | Exostellar Management Server (EMS) instance's root volume type. Valid options: standard, gp2, gp3, io1, io2, sc1, and st1. | `string` | `"gp2"` | no |
| enable_infrastructure_optimizer | Enable Infrastructure Optimizer (IO) for xspot? | `bool` | `true` | no |
| enable_workload_optimizer | Enable Workload Optimizer (WO) for xspot? | `bool` | `true` | no |
| exo_cni_chart_namespace | Exostellar's CNI chart's namespace. | `string` | `"kube-system"` | no |
| exo_cni_chart_repository | Exostellar's CNI chart's repository URL. | `string` | `"oci://public.ecr.aws/u8h5n6o4/exostellar-cni/exo-aws-vpc-cni"` | no |
| exo_cni_chart_version | Exostellar's CNI chart's version. | `string` | `"1.20.0"` | no |
| exo_csi_chart_namespace | Exostellar's CSI chart's namespace. | `string` | `"kube-system"` | no |
| exo_csi_chart_repository | Exostellar's CSI chart's repository URL. | `string` | `"oci://public.ecr.aws/u8h5n6o4/exostellar-csi/exo-aws-ebs-csi-driver"` | no |
| exo_csi_chart_version | Exostellar's CSI chart's version. | `string` | `"1.46.0"` | no |
| guest_kernel_version | Guest kernel version for xspot nodes. | `string` | `"5.15.185"` |
| license_filepath | The Exostellar's license file name/path. | `string` | `""` | no |
| nfs_dns_name | DNS name of the NFS file system for Exostellar Management Server (EMS). | `string` | `""` | no |
| nfs_security_group_id | Security group ID that enable traffic between the NFS server and Exostellar Management Server (EMS). | `string` | `""` | no |
| permissions_boundary_arn | Optional ARN of an IAM policy to use as a permissions boundary for IAM roles created by the IAM and EMS modules. | `string` | `null` | yes |
| pod_resource_limits | Pod resource requests and limits. | <pre>map(<br>  object(<br>    {<br>      cpu    = number<br>      memory = string<br>    },<br>  ),<br>) | <pre>{<br>  requests = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>  limits = {<br>    cpu    = 1<br>    memory = "1Gi"<br>  }<br>} | no |
| profile_availability_zone | Exostellar profile's availability zone. | `string` | `""` | no |
| ssh_key_name | SSH key-pair's name in AWS for Exostellar Management Server (EMS)'s access. If ssm_enabled is set to true, this will be skipped. | string | `null` | no |
| ssm_enabled | Enable AWS Systems Manager (SSM) for Exostellar Management Server (EMS)? | `false` | `bool` | no |
| vpc_cidr | CIDR for VPC to be created. | `string` | `"10.0.0.0/16"` | no |
| xkarpenter_helm_chart_repository | Exostellar's Karpenter (xkarpenter)'s Helm chart's repository URL. | `string` | `"oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter"` | no |
| xkarpenter_namespace | Exostellar's Karpenter (xkarpenter)'s namespace. | `string` | `"exokarpenter"` | no |
| xkarpenter_resources_helm_chart_repository | Exostellar's Karpenter (xkarpenter)'s resources (ExoNodeClass and ExoNodePool) Helm chart's repository URL. | string | `"oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter-resources"` | no |
| xkarpenter_version | Exostellar's Karpenter (xkarpenter)'s Helm chart's version. Note: To keep xKarpenter and xKarpenter Resources compatible, same version is used with both charts. | string | `"v2.0.6"` | no |
| xspot_enable_balloon | Enable ballooning in Xspot? | `bool` | `true` | no |
| xspot_enable_hyperthreading | Enable hyperthreading in Xspot? | `bool` | `true` | no |
| xspot_version | Xspot (controller and worker) version to use. | `string` | `"xspot-3.4.0"` | no |

## Outputs

| Name | Description |
|------|-------------|
| exostellar_management_server_public_ip | Exostellar Management Server (EMS)'s public IP. |
| exostellar_management_server_private_ip | Exostellar Management Server (EMS)'s private IP. |
| exostellar_management_server_console_admin_username | Exostellar Management Server (EMS) console's admin username for login. |
| exostellar_management_server_console_admin_password | Exostellar Management Server (EMS) console's initial admin password for login. Change on first login. |
