module "existing_cluster_flow" {
  # Use the latest existing-cluster-full module release as source. This is the recommended approach to import the
  # existing-cluster-full module from anywhere, for production.
  #
  # In case of running in this repository, you may use the relative path to the existing-cluster-full module's
  # directory.
  # Note: This is not recommended for production as the local existing-cluster-full module may contain untested changes.
  # source = "../../modules/existing-cluster-full"
  # 
  source = "git::ssh://git@github.com/Exostellar/terraform-exostellar-modules//modules/existing-cluster-full?ref=v0.0.5"

  ####################
  # Mandatory Inputs #
  ####################

  # EKS Cluster Inputs:
  # 
  # EKS cluster's name. It must be between 1 and 26 characters in length.
  eks_cluster = "my-exostellar-cluster"
  # AWS region of the EKS cluster.
  aws_region = "us-east-1"

  # Exostellar Management Server (EMS) Inputs:
  # 
  # EMS AMI for the selected aws_region.
  ems_ami_id = "ami-XXXXXXXXXXXXXXXXX"
  # SSH key-pair's name in AWS for Exostellar Management Server (EMS)'s access. Default is "".
  # This is not technically a mandatory field, but would be required when `ssm_enabled` is set to false. If
  # `ssm_enabled` is set to true, this will be skipped.
  ssh_key_name = "my-ssh-key-pair-name"
  # The Exostellar's license file name/path. Default is "".
  # This is not technically a mandatory field, but would be required for the Exostellar Management Server (EMS) to
  # operate. If you provide an empty string (""), the Terraform modules will skip adding the license. You can add the
  # license later by logging in to the EMS UI and uploading it from the **Settings** page.
  license_filepath = "/path/to/exo-license-file"

  ###################
  # Optional Inputs #
  ###################

  # Exostellar Management Server (EMS) Inputs:
  #
  # EC2 instance type for Exostellar Management Server (EMS). Default is "m5d.xlarge".
  ems_instance_type = "m5d.xlarge"
  # Exostellar Management Server (EMS) instance's root volume size (in GB). Default is 100.
  ems_volume_size_gb = 100
  # Delete the Exostellar Management Server (EMS) instance's root volume on termination of instance? Default is true.
  ems_volume_delete_on_termination = true
  # Encrypt the Exostellar Management Server (EMS) instance's root volume? Default is false.
  ems_volume_encryption = false
  # Exostellar Management Server (EMS) instance's root volume type. Valid options: standard, gp2, gp3, io1, io2, sc1,
  # and st1. Default is "gp2".
  ems_volume_type = "gp2"
  # Enable termination protection for Exostellar Management Server (EMS)'s EC2 instance? Default is true.
  ems_termination_protection = true
  # Domain name to run Exostellar Management Server (EMS) in. Default is "".
  domain_name = ""
  # DNS name of the NFS file system for Exostellar Management Server (EMS). Default is "".
  nfs_dns_name = ""
  # Security group ID that enable traffic between the NFS server and Exostellar Management Server (EMS). Default is "".
  nfs_security_group_id = ""

  # Xspot Inputs:
  #
  # Enable hyperthreading in Xspot? Default is true.
  xspot_enable_hyperthreading = true
  # Enable ballooning in Xspot? Default is true.
  xspot_enable_balloon = true
  # Enable inbound traffic to x-spot worker? Default is true.
  allow_xspot_worker_inbound_traffic = true
  # Xspot (controller and worker) version to use. Default is "xspot-3.4.0".
  xspot_version = "xspot-3.4.0"
  # Enable Infrastructure Optimizer (IO) for xspot? Default is true.
  enable_infrastructure_optimizer = true
  # Enable Workload Optimizer (WO) for xspot? Default is true.
  enable_workload_optimizer = true

  # CNI and CSI Inputs:
  # 
  # Exostellar's CNI chart's repository URL. Default is "oci://public.ecr.aws/u8h5n6o4/exostellar-cni/exo-aws-vpc-cni".
  exo_cni_chart_repository = "oci://public.ecr.aws/u8h5n6o4/exostellar-cni/exo-aws-vpc-cni"
  # Exostellar's CNI chart's version. Default is "1.20.0".
  exo_cni_chart_version = "1.20.0"
  # Exostellar's CNI chart's namespace. Default is "kube-system".
  exo_cni_chart_namespace = "kube-system"
  # Exostellar's CSI chart's repository URL. Default is
  # "oci://public.ecr.aws/u8h5n6o4/exostellar-csi/exo-aws-ebs-csi-driver".
  exo_csi_chart_repository = "oci://public.ecr.aws/u8h5n6o4/exostellar-csi/exo-aws-ebs-csi-driver"
  # Exostellar's CSI chart's version. Default is "1.46.0".
  exo_csi_chart_version = "1.46.0"
  # Exostellar's CSI chart's namespace. Default is "kube-system".
  exo_csi_chart_namespace = "kube-system"

  # Exostellar Karpenter (xKarpenter) Inputs:
  # 
  # Exostellar's Karpenter (xkarpenter)'s Helm chart's repository URL. Default is
  # "oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter".
  xkarpenter_helm_chart_repository = "oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter"
  # Exostellar's Karpenter (xkarpenter)'s resources (ExoNodeClass and ExoNodePool) Helm chart's repository URL.
  # Default is "oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter-resources".
  xkarpenter_resources_helm_chart_repository = "oci://public.ecr.aws/u8h5n6o4/exostellar-karpenter/karpenter-resources"
  # Exostellar's Karpenter (xkarpenter)'s Helm chart's version. Default is "v2.0.6".
  # Note: To keep xKarpenter and xKarpenter Resources compatible, same version is used with both charts.
  xkarpenter_version = "v2.0.6"
  # Exostellar's Karpenter (xkarpenter)'s namespace. Default is "exokarpenter".
  xkarpenter_namespace = "exokarpenter"
  # Guest kernel version for xspot nodes. Default is "5.15.185".
  guest_kernel_version = "5.15.185"
  # Pod resource requests and limits. Default is
  # {requests: { cpu: 1, memory: "1Gi" }, limits: { cpu: 1, memory: "1Gi" }}.
  pod_resource_limits = {
    requests = {
      cpu    = 1
      memory = "1Gi"
    }
    limits = {
      cpu    = 1
      memory = "1Gi"
    }
  }

  # Miscellaneous Inputs:
  #
  # Prefix to use for all AWS resources. Note: This will not add any trailing extra characters like '-'. Default is "".
  aws_resource_prefix = ""
  # Enable AWS Systems Manager (SSM) for Exostellar Management Server (EMS)? Default is false.
  ssm_enabled = false
}
