# Partner Branch Workflow - DataRobot

Welcome! This document explains how DataRobot can collaborate with Exostellar in our shared GitHub repository.

## Overview

We've created a dedicated branch namespace so you can move faster!

* **Namespace:** `partner/datarobot/*`
* **Access:** DataRobot has **read/write** access in this namespace only.
* **Core Protection:** Exostellar reviews all core changes (`main`, policies, CI config, etc.).

## Workflow

1. **Create a branch** under `partner/datarobot/*` (e.g. `partner/datarobot/feature-x`).
2. **Push and PR** as normal within your namespace.
3. **Core changes** (outside your namespace) require Exostellar review and approval.

## Security

* No stored secrets; GitHub OIDC handles cloud auth.
* Branch protections: no force-push, no deletions, signed commits required.
* Exostellar can see all partner branch activity in real time.

## Support

* For any questions please use the Slack channel `#datarobot-exostellar` or tag a maintainer of the repo if needed.

---

**Summary:**
DataRobot has a safe sandbox (`partner/datarobot/*`) for rapid development, while Exostellar keeps the core stable. This gives us speed, security, and visibility without friction.
