# Configuring AWS CSI for Exostellar

This guide explains how to configure the preinstalled AWS EBS CSI driver [aws-ebs-csi-driver][AWS CSI] on an existing
EKS cluster. The goal is to ensure Exostellar's Terraform modules can deploy and the Exostellar components operate on
the cluster without any storage conflicts.

> **Note**: If you're using a different CSI plugin for your EKS cluster, consult its documentation for equivalent steps.

---

## 1. Prevent AWS CSI from Running on `x-compute` Nodes

The default AWS CSI must not handle storage on these nodes. The `x-compute` nodes are managed by the Exostellar CSI
(Exo-CSI), which Terraform modules will install. For it to work seamlessly, adjust the AWS CSI daemonSet's node affinity
so that it does not run on `x-compute` nodes.

### Steps

1. **Check the AWS CSI daemonSet's node affinity:**

    ```bash
    kubectl get daemonset ebs-csi-node -n kube-system \
      -o jsonpath='{.spec.template.spec.affinity.nodeAffinity.requiredDuringSchedulingIgnoredDuringExecution.nodeSelectorTerms[*]}' \
      | jq
    ```

2. **Verify the output contains the following condition:**

    ```json
    {
      "key": "eks.amazonaws.com/nodegroup",
      "operator": "NotIn",
      "values": ["x-compute"]
    }
    ```

3. **If missing, patch the daemonSet:**

    ```bash
    kubectl get daemonset ebs-csi-node -n kube-system -o json \
      | jq '.spec.template.spec.affinity.nodeAffinity
            .requiredDuringSchedulingIgnoredDuringExecution
            .nodeSelectorTerms[0].matchExpressions += [
              {
                "key": "eks.amazonaws.com/nodegroup",
                "operator": "NotIn",
                "values": ["x-compute"]
              }
            ]' \
      | kubectl apply -f -
    ```

---

## 2. Annotate EBS CSI Driver's Service Account with IAM Role ARN for IRSA

The IAM Role for Service Account (IRSA) for the Amazon EBS CSI driver is required. The CSI driver (through the service
account) assumes the IAM role for accessing the AWS API for managing the EBS volumes, etc.

The IAM role will be created in the Terraform modules, in the `iam-ebs-csi-driver-irsa` step. But annotating the service
account should be done manually before `terraform apply` as the Amazon EBS CSI driver will be out of scope for Terraform
modules in case of an existing cluster flow.

### Steps

1. **Check if the annotation is already present:**

    ```bash
    kubectl get sa ebs-csi-controller-sa \
        -n kube-system \
        -o jsonpath='{.metadata.annotations.eks\.amazonaws\.com/role-arn}'
    ```

2. **Annotate the service account:**

    ```bash
    kubectl annotate serviceaccount/ebs-csi-controller-sa \
      -n kube-system \
      "eks.amazonaws.com/role-arn=arn:aws:iam::<aws-account-id>:role/<cluster-name>-ebs-csi"
    ```
    > Replace `<aws-account-id>` and `<cluster-name>` in the above command with your AWS account ID and cluster name,
      respectively.

3. **Restart driver pods:**

    Since the old driver pods will continue to refer to the old service account state (i.e., without the annotation),
    you have to force restart the pods.

    ```bash
    kubectl delete pod -n kube-system -l app.kubernetes.io/name=aws-ebs-csi-driver
    kubectl wait pods -n kube-system -l app.kubernetes.io/name=aws-ebs-csi-driver --for=condition=ready --timeout=300s
    ```

> [!NOTE]
> You need to restart these pods before each `terraform apply`, regardless of whether any manual changes were made to
the AWS-CSI since the last run.

---

[AWS CSI]: 
  https://github.com/kubernetes-sigs/aws-ebs-csi-driver
