# Configuring AWS CNI for Exostellar

This guide explains how to configure the preinstalled AWS VPC CNI [amazon-vpc-cni-k8s][AWS CNI] on an existing EKS
cluster. The goal is to ensure Exostellar's Terraform modules can deploy and the Exostellar components operate on the
cluster without any networking conflicts.

> **Note**: If you're using a different CNI plugin for your EKS cluster, consult its documentation for equivalent steps.

---

## 1. Prevent AWS CNI from Running on `x-compute` Nodes

The default AWS CNI must not handle networking on these nodes. The `x-compute` nodes are managed by the Exostellar CNI
(Exo-CNI), which Terraform modules will install. For it to work seamlessly, adjust the AWS CNI daemonSet's node affinity
so that it does not run on `x-compute` nodes.

### Steps

1. **Check the AWS CNI daemonSet's node affinity:**

    ```bash
    kubectl get daemonset aws-node -n kube-system \
      -o jsonpath='{.spec.template.spec.affinity.nodeAffinity.requiredDuringSchedulingIgnoredDuringExecution.nodeSelectorTerms[*]}' \
      | jq
    ```

2. **Verify the output contains the following condition:**

    ```json
    {
      "key": "eks.amazonaws.com/nodegroup",
      "operator": "NotIn",
      "values": ["x-compute"]
    }
    ```

3. **If missing, patch the daemonSet:**

    ```bash
    kubectl get daemonset aws-node -n kube-system -o json \
      | jq '.spec.template.spec.affinity.nodeAffinity
            .requiredDuringSchedulingIgnoredDuringExecution
            .nodeSelectorTerms[0].matchExpressions += [
              {
                "key": "eks.amazonaws.com/nodegroup",
                "operator": "NotIn",
                "values": ["x-compute"]
              }
            ]' \
      | kubectl apply -f -
    ```

---

## 2. Disable `AWS_VPC_K8S_CNI_CUSTOM_NETWORK_CFG`

When the environment variable `AWS_VPC_K8S_CNI_CUSTOM_NETWORK_CFG` is enabled on the AWS CNI, primary Elastic Network
Interfaces (ENIs) are ignored, preventing Exostellar CNI (Exo-CNI) from functioning on `x-compute` nodes. Ensure it is
set to `false`.

For more information on this variable, see the [AWS CNI documentation][AWS_VPC_K8S_CNI_CUSTOM_NETWORK_CFG].

### Steps

1. **Check the current value:**

    ```bash
    kubectl get daemonset aws-node -n kube-system -o json \
      | jq -r '.spec.template.spec.containers[]
        | select(.name=="aws-node")
        | .env[]
        | select(.name=="AWS_VPC_K8S_CNI_CUSTOM_NETWORK_CFG")
        | "\(.name)=\(.value)"'
    ```

2. **Expected output:**

    ```toml
    AWS_VPC_K8S_CNI_CUSTOM_NETWORK_CFG=false
    ```

3. **If missing or set to `true`, update it:**

    ```bash
    kubectl set env daemonset/aws-node -n kube-system -c aws-node AWS_VPC_K8S_CNI_CUSTOM_NETWORK_CFG=false
    ```

---

[AWS CNI]: 
  https://github.com/aws/amazon-vpc-cni-k8s

[AWS_VPC_K8S_CNI_CUSTOM_NETWORK_CFG]: 
  https://github.com/aws/amazon-vpc-cni-k8s?tab=readme-ov-file#aws_vpc_k8s_cni_custom_network_cfg
