# Platforms

Currently, `x-install` only supports X-IO installation in an AWS EKS environment. 
This will be extended to include other platforms like HPC and LSF.

One implementation proposal is to introduce new parent platform subcommands that:

* inherits from the root `x-install` command
* contains all platform-specific subcommands and flagsets

For example, all the existing subcommands will be moved under the new `eks` 
subcommand. A new `hpc` subcommand can be added to support HPC with its own set
of subcommands following the pattern of the `eks`'s children subcommands.

The underlying API calls, environment assessment and template rendering code can 
still be shared between the different platform commands.

Essentially, the structure of the `x-install` command will look like this:

```sh
x-install
├── version
├── eks
│   ├── create-standalone
│   ├── precheck
│   ├── apply
│   ├── eksconfig
│   ├── post-install
│   ├── destroy
│   └── update-kubeconfig
├── hpc
│   ├── create-standalone
│   ├── precheck
│   ├── apply
│   ├── eksconfig
│   ├── post-install
│   ├── destroy
│   └── update-kubeconfig
├── lsf
│   ├── create-standalone
│   ├── precheck
│   ├── apply
│   ├── eksconfig
│   ├── post-install
│   ├── destroy
│   └── update-kubeconfig
```

The `cmd/flagsets.go` file groups together common flagsets that platform 
subcommands can re-use. New flagsets can also be added to this file.
