# x-install

x-install is the Exostellar installer tool. It provides a number of subcommands to 
install X-IO, assess and discover the target installation environment and report
the post-install readiness of X-IO.

## Quick Start

Install the following software:

* Terraform 1.8+
* Git 2.34+
* Valid marketplace subscriptions to Exostellar X-IO Management Server,
controller and worker AMIs
* Configure the AWS access credentials per AWS documentation
[here](https://docs.aws.amazon.com/cli/v1/userguide/cli-chap-configure.html)

> 📝 See the [permissions specification documentation](./docs/permissions.md) for
> the required AWS permissions.

> 📝 Before proceeding with running `x-install create-standalone`, ensure that
> the AWS account has capacity for 1 new VPC, 1 new EKS cluster, 1 EIP, 1 public
> NAT Gateway and 1 Internet Gateway.

Use the following command to create a standalone X-IO stack named `xio-standalone`
in the `us-west-1` region:

```sh
x-install create-standalone \
  --stack-name=xio-standalone \
  --vpc-cidr=10.0.0.0/16 \
  --ssh-key-pair-name=my-dev-key \
  --region=us-west-1
```

The new VPC and EKS cluster will be named after the stack name. The VPC is 
assigned the 10.0.0.0/16 CIDR block. The EC2 SSH key pair `my-dev-key` can 
later be used to access the X-IO Management Server.

The stack name, VPC CIDR, SSH key pair name and region should be adjusted to 
suit your environment.

Once the `create-standalone` command completed successfully, use the next command
to confirm X-IO service readiness:

```sh
x-install post-install --stack-name=xio-standalone
```

> 📝 It might take a few attempts for `post-install` to pass all system units and
> containers readiness checks, due to infrastructure readiness latency.

Once the post-install checks completed successfully, add an x-compute node to the
standalone EKS cluster using the `eks-node-cli` tool found on the X-IO Management
Server:

```sh
# ssh to the X-IO Management Server
$ ssh rocky@<management-server-public-ip>

# on the X-IO Management Server, add a new node to the standalone EKS cluster
eks-node-cli add -n node-00 -c 1 -m 4096 -p pool-a -r az1 -k xio-standalone
```

The new node can be verified using the `kubectl` command:
```sh
$ kubectl get node -l eks.amazonaws.com/nodegroup=x-compute
NAME                                          STATUS   ROLES    AGE     VERSION
ip-10-0-39-220.us-west-1.x-compute.internal   Ready    <none>   4m17s   v1.29.3-eks-ae9a62a
```

By default, the EKS token used to access the standalone EKS cluster expired after
60 minutes. Following that, all attempts to access the cluster will fail with
`Unauthorized` errors.

To generate a new EKS token and use it with your existing `kubeconfig` file, run:

```sh
x-install update-kubeconfig --stack-name=xio-standalone
```

Once the free trial period is over, the entire standalone stack can be deleted with
the `destroy` command:

```sh
x-install destroy --stack-name xio-standalone
```

Sometimes, Terraform might time out during the destroy process. Re-running the
destroy command will allow Terraform to reconcile its final state.

> 📝 At this time, all controllers and workers EC2 instances need to be manually
> terminated.

For more information on other subcommands, run:

```sh
x-install help
```

## API Authentication

x-install supports the usual AWS and Kubernetes authentication mechanisms by
looking for configuration files in the following paths:

* ~/.aws/config
* ~/.aws/credentials
* ~/.kube/config

## Design

See the [install flow design documentation](./docs/install-flow.md) for
more information on the design of the install flow.

The criteria for successful precheck and post-install runs are defined in
the [criteria design documentation](./docs/criteria.md).

The provider-specific roles and permissions required by `x-install` are defined 
in the [permissions specification documentation](./docs/permissions.md).

`x-install` defines Terraform modules to create the necessary AWS resources. See
the [states design documentation](./docs/states.md) for more information on how
`x-install` manages the modules' state files.

Currently, `x-install` only supports installation in an AWS EKS environment. This
will be extended to include other platforms like HPC and LSF. See the [platforms
design documentation](./docs/platforms.md) for more information.

## Development

See the [BUILD](./BUILD.md) file.

## Release

See the [RELEASE](./RELEASE.md) file.

## License

See the [LICENSE](./LICENSE) file.
