# Install Flow

This document describes the high level installation flow of X-IO.

The `x-install` tool aims to provide a simple and consistent installation
experience, by automating the steps described in this document. The tool can
be downloaded from the release page of this GitHub repository.

![install flow PNG](png/install-flow.png)

## General Installation

The typical workflow begins with the user assessing their target environment to
determine its suitability for X-IO installation. This step involves performing
a set of precheck criteria against the target environment.

User should not proceed with the X-IO installation if the pre-check step failed.

The next step is to install the X-IO software on the target environment. This
will be done by running the `x-install apply` command. During the installation,
`x-install` will also auto-configure the environment-specific X-IO profile
and application environment.

Once the X-IO software is installed, the user can SSH into the X-IO management
server and run the pre-bundled `test_createVm.sh` script to spin up a X-Spot
controller and worker. Instructions on how to run the script can be found in
the Exostellar documentation at https://docs.exostellar.io.

For EKS user, the next step involves configuring the EKS cluster by:

* Updating the `aws-auth` configmap with the X-Spot controller and worker roles
* Updating the `aws-node` CNI daemonset with the X-IO pod affinity configuration
* Install the `exo-aws-node` CNI daemonset

All of these steps are wrapped in the `x-install eksconfig` command to ease
the configuration experience.

When all the configuration is completed, user can confirm X-IO's system readiness
by running a set of post-install checks, as provided by the `x-install post-install`
command.

## Standalone Stack

For a complete free-trial experience, user can choose to install the X-IO standalone
stack which comprised of a new VPC, EKS cluster and X-IO. This installation is
automated by the `x-install` tool.

User is responsible for ensuring that their AWS account has the necessary permissions
and quota to provision these additional VPC resources.

## Separate IAM Resources Installation

For organization where the cloud infrastructure and IAM resources are managed
separately by a different cloud admin team, user can choose to install the
IAM resources separately using the `x-install precheck`.
