# Precheck Criteria

The `precheck` command assesses the target environment to determine its
suitability for X-IO installation. This document describes the list of
criteria that `precheck` uses.

> ⚠️  Do not proceed with the X-IO installation until all the criteria are
> met. If you have any questions or need assistance, please contact Exostellar.

## EKS

In an EKS environment, `precheck` begins by determining the region and version of
the EKS cluster.

The EKS cluster must be in the `ACTIVE` state. Any cluster-level health issues
issues reported by the EKS API will be surfaced.

The EKS API Server's endpoint access should be configured to be publicly
accessible. A warning will be issued if the public access endpoint is
disabled. For more information on network access to the EKS API server
endpoint, see the 
[EKS documentation](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html).

All the active EKS nodegroups are assessed for node-level health issues. The IAM
role of each nodegroup is identified. User is responsible for ensuring that these
roles have the default set of permissions as described in the
[EKS documentation](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html).

The cluster security group and any additional security groups are identified. The
cluster security group will be shared with the X-IO management server when
installing X-IO later.

## VPC

The `precheck` command assess the following information about the VPC in
which the cluster is running in:

* VPC ID, region and CIDR
* DHCP options configuration
* Public subnets and their Internet Gateway
* Private subnets and their NAT Gateway

The DHCP options configuration must have a non-empty domain name and a non-empty
domain name server.

A subnet is regarded as a valid public subnet if it has a route entry associated
with a Internet Gateway. To ensure assess to the AWS API, the public subnet must
have the `Auto-assign Public IP On Launch` attribute enabled.

Conversely, a valid private subnet is one that has a route entry associated with
a NAT Gateway.

By default, the X-IO Management Server will be assigned to run in the first valid
public subnets. X-Spot controller and workers will be run in the first valid
private subnets.

Warnings are issued if no valid DHCP options, public or private subnets are found.

## IAM

The `precheck` command tries to find IAM resources required by X-IO. If these
resources are missing, it will auto-install them by running the `xio-iam`
Terraform module.

The following is the list of required X-IO IAM resources:

* The controller IAM role
* The controller IAM instance profile
* The worker IAM role
* The worker IAM instance profile

The `xio-iam` module contains the policy documents for these roles. This module
is normally saved to the `~/.xio/<cluster-name>/xio-iam.states` folder by the
`precheck` command. Alternately, it can also be downloaded prior to running
`precheck` from the S3 bucket shown by the `x-install version` command.

## Marketplace Subscriptions

The `precheck` command confirms the user's AWS account has subscribed to the
following Exostellar AWS Marketplace subscriptions:

Product Title                | Entity ID
-----------------------------|----------
Exostellar Management Server | prod-crdnafbqnbnm2
Controller                   | prod-d4lifqwlw4kja
Worker                       | prod-2smeyk5fuxt7q

If any of these subscriptions are missing, the `precheck` command will issue a
warning.

## AMIs

The `precheck` command identifies the list of regional X-IO AMIs and EBS
snapshots that the user's AWS account has access to. It reports the total
number of image artifacts found, and report the IDs of the most recent ones.

If none is found, warnings will be issued. User should contact Exostellar to
get access.

Since AWS resource tags are not shared across accounts, the `precheck` command
relies on the AMIs and EBS snapshots names for discovery. The following is the
name pattern used:

Base OS     | Controller AMI Name Pattern | Worker AMI Name Pattern
------------|-----------------------------|------------------------
Centos      | *-controller-xspot-*        | *-worker-xspot-*
Rocky Linux | xspot-controller-*     | xspot-worker-*

ENS Snapshot Name Pattern:

* Ubuntu: `ubuntu-build*`
* Kubernete: `k8s-*-build*`

## EKS CNI

For EKS environment, the `precheck` command will also determine if the AWS CNI,
Exo CNI and Calico CNI are installed. Other CNI plugins may not be supported.
Contact Exostellar for more information.

## Karpenter

For EKS environment, the `precheck` command will also determine if Karpenter is
installed. Since Karpenter is currently incompatible with xKarpenter, `precheck`
will issue a warning if Karpenter is found. Please contact Exostellar for more
information.
